/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.tileentity;

import hardcorequesting.common.forge.blocks.ModBlocks;
import hardcorequesting.common.forge.blocks.TrackerBlock;
import hardcorequesting.common.forge.client.ClientChange;
import hardcorequesting.common.forge.client.interfaces.EditTrackerScreen;
import hardcorequesting.common.forge.client.interfaces.GuiType;
import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.tileentity.TrackerType;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TrackerBlockEntity
extends BlockEntity {
    private static final String NBT_QUEST = "Quest";
    private static final String NBT_RADIUS = "Radius";
    private static final String NBT_TYPE = "TrackerType";
    private Quest quest;
    private UUID questId;
    private int radius;
    private TrackerType type = TrackerType.TEAM;
    private int delay = 0;

    public TrackerBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.typeTracker.get(), pos, state);
    }

    private static TrackerBlockEntity getTracker(Level world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        return te instanceof TrackerBlockEntity ? (TrackerBlockEntity)te : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openInterface(Player player, BlockPos pos, UUID questId, int radius, TrackerType type) {
        TrackerBlockEntity tracker = TrackerBlockEntity.getTracker(player.m_9236_(), pos);
        if (tracker != null) {
            tracker.questId = questId;
            tracker.quest = null;
            tracker.radius = radius;
            tracker.type = type;
            EditTrackerScreen gui = new EditTrackerScreen(tracker);
            Minecraft.m_91087_().m_91152_((Screen)gui);
        }
    }

    public static void saveToServer(Player player, BlockPos pos, int radius, TrackerType type) {
        TrackerBlockEntity tracker = TrackerBlockEntity.getTracker(player.m_9236_(), pos);
        if (Quest.canQuestsBeEdited() && tracker != null) {
            tracker.radius = radius;
            tracker.type = type;
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.questId = compound.m_128342_(NBT_QUEST);
        this.radius = compound.m_128451_(NBT_RADIUS);
        this.type = TrackerType.values()[compound.m_128445_(NBT_TYPE)];
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        if (this.quest != null) {
            compoundTag.m_128362_(NBT_QUEST, this.quest.getQuestId());
        }
        compoundTag.m_128405_(NBT_RADIUS, this.radius);
        compoundTag.m_128344_(NBT_TYPE, (byte)this.type.ordinal());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TrackerBlockEntity blockEntity) {
        if (blockEntity.quest == null && blockEntity.questId != null) {
            blockEntity.quest = Quest.getQuest(blockEntity.questId);
            blockEntity.questId = null;
        }
        if (!level.m_5776_() && blockEntity.delay++ == 20) {
            if (blockEntity.quest != null && Quest.getQuest(blockEntity.quest.getQuestId()) == null) {
                blockEntity.quest = null;
            }
            int power = blockEntity.quest != null ? blockEntity.type.getPower(blockEntity, blockEntity.quest, blockEntity.radius) : 0;
            if ((Integer)state.m_61143_((Property)TrackerBlock.POWER) != power) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)TrackerBlock.POWER, (Comparable)Integer.valueOf(power)), 3);
            }
            blockEntity.delay = 0;
        }
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public TrackerType getTrackerType() {
        return this.type;
    }

    public void setTrackerType(TrackerType type) {
        this.type = type;
    }

    public void setCurrentQuest() {
        this.quest = Quest.getQuest(Quest.speciallySelectedQuestId);
    }

    public Quest getCurrentQuest() {
        return this.quest;
    }

    public void openInterface(Player player) {
        if (player instanceof ServerPlayer) {
            NetworkManager.sendToPlayer(GuiType.TRACKER.build(this.build()), (ServerPlayer)player);
        }
    }

    private String[] build() {
        String[] data = new String[]{"" + this.f_58858_.m_121878_(), this.quest != null ? this.quest.getQuestId().toString() : null, "" + this.radius, "" + this.type.ordinal()};
        return data;
    }

    public void sendToServer() {
        NetworkManager.sendToServer(ClientChange.TRACKER_UPDATE.build((Object)this));
    }
}

