/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.tileentity;

import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestingData;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.team.PlayerEntry;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.team.TeamManager;
import hardcorequesting.common.forge.tileentity.TrackerBlockEntity;
import hardcorequesting.common.forge.util.Translator;
import java.util.UUID;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TrackerType {
    TEAM("team"){

        @Override
        public int getPower(TrackerBlockEntity tracker, Quest quest, int radius) {
            int meta = 0;
            for (Team team : TeamManager.getInstance().getTeams()) {
                boolean valid;
                if (!team.getQuestData((UUID)quest.getQuestId()).completed) continue;
                boolean bl = valid = radius == 0;
                if (!(valid = TrackerType.isValid(valid, team, tracker, radius)) || ++meta != 15) continue;
                break;
            }
            return meta;
        }
    }
    ,
    PLAYER("player"){

        @Override
        public int getPower(TrackerBlockEntity tracker, Quest quest, int radius) {
            int meta = 0;
            block0: for (Team team : TeamManager.getInstance().getTeams()) {
                if (!team.getQuestData((UUID)quest.getQuestId()).completed) continue;
                for (PlayerEntry entry : team.getPlayers()) {
                    Player player;
                    boolean valid;
                    if (!entry.isInTeam()) continue;
                    boolean bl = valid = radius == 0;
                    if (!valid && (player = QuestingData.getPlayer(entry.getUUID())) != null && TrackerType.isPlayerWithinRadius(tracker, player, radius)) {
                        valid = true;
                    }
                    if (!valid || ++meta != 15) continue;
                    continue block0;
                }
            }
            return meta;
        }
    }
    ,
    PROGRESS_MAX("progressMax"){

        @Override
        public int getPower(TrackerBlockEntity tracker, Quest quest, int radius) {
            int meta = 0;
            for (Team team : TeamManager.getInstance().getTeams()) {
                boolean valid;
                int newMeta = (int)(quest.getProgress(team) * 15.0f);
                if (newMeta <= meta) continue;
                boolean bl = valid = radius == 0;
                if (!(valid = TrackerType.isValid(valid, team, tracker, radius))) continue;
                meta = newMeta;
            }
            return meta;
        }
    }
    ,
    PROGRESS_CLOSE("progressClose"){

        @Override
        public int getPower(TrackerBlockEntity tracker, Quest quest, int radius) {
            double closest = 0.0;
            ServerPlayer closestPlayer = null;
            for (ServerPlayer player : HardcoreQuestingCore.getServer().m_6846_().m_11314_()) {
                double distance = player.m_20275_((double)tracker.m_58899_().m_123341_() + 0.5, (double)tracker.m_58899_().m_123342_() + 0.5, (double)tracker.m_58899_().m_123343_() + 0.5);
                if (closestPlayer != null && !(distance < closest)) continue;
                closest = distance;
                closestPlayer = player;
            }
            if (closestPlayer != null) {
                return (int)(quest.getProgress(QuestingDataManager.getInstance().getQuestingData((Player)closestPlayer).getTeam()) * 15.0f);
            }
            return 0;
        }
    };

    private String id;

    private TrackerType(String name) {
        this.id = name;
    }

    private static boolean isPlayerWithinRadius(TrackerBlockEntity tracker, Player player, int radius) {
        return player.m_20275_((double)tracker.m_58899_().m_123341_() + 0.5, (double)tracker.m_58899_().m_123342_() + 0.5, (double)tracker.m_58899_().m_123343_() + 0.5) < (double)(radius * radius);
    }

    private static boolean isValid(boolean valid, Team team, TrackerBlockEntity tracker, int radius) {
        if (!valid) {
            for (PlayerEntry entry : team.getPlayers()) {
                Player player;
                if (!entry.isInTeam() || (player = QuestingData.getPlayer(entry.getUUID())) == null || !TrackerType.isPlayerWithinRadius(tracker, player, radius)) continue;
                return true;
            }
        }
        return valid;
    }

    public FormattedText getName() {
        return Translator.translatable("hqm.tracker." + this.id + ".title", new Object[0]);
    }

    public FormattedText getDescription() {
        return Translator.translatable("hqm.tracker." + this.id + ".desc", new Object[0]);
    }

    public abstract int getPower(TrackerBlockEntity var1, Quest var2, int var3);
}

