/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.util;

import hardcorequesting.common.forge.util.Translator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public enum EditType {
    QUEST_CREATE(BaseEditType.ADD, Type.QUEST),
    QUEST_REMOVE(BaseEditType.REMOVE, Type.QUEST),
    TASK_CREATE(BaseEditType.ADD, Type.TASK),
    TASK_REMOVE(BaseEditType.REMOVE, Type.TASK),
    TASK_CHANGE_TYPE(BaseEditType.ADD, Type.TASK_TYPE),
    REQUIREMENT_CHANGE(BaseEditType.CHANGE, Type.REQUIREMENT),
    REQUIREMENT_REMOVE(BaseEditType.REMOVE, Type.REQUIREMENT),
    REPEATABILITY_CHANGED(BaseEditType.CHANGE, Type.REPEATABILITY),
    VISIBILITY_CHANGED(BaseEditType.CHANGE, Type.VISIBILITY),
    PARENT_REQUIREMENT_CHANGED(BaseEditType.CHANGE, Type.PARENT),
    OPTION_CHANGE(BaseEditType.ADD, Type.OPTION),
    OPTION_REMOVE(BaseEditType.REMOVE, Type.OPTION),
    NAME_CHANGE(BaseEditType.CHANGE, Type.NAME),
    DESCRIPTION_CHANGE(BaseEditType.CHANGE, Type.DESCRIPTION),
    ICON_CHANGE(BaseEditType.CHANGE, Type.ICON),
    QUEST_SIZE_CHANGE(BaseEditType.CHANGE, Type.QUEST_SIZE),
    QUEST_MOVE(BaseEditType.MOVE, Type.QUEST),
    QUEST_CHANGE_SET(BaseEditType.MOVE, Type.BETWEEN_SETS),
    SET_CREATE(BaseEditType.ADD, Type.SET),
    SET_REMOVE(BaseEditType.REMOVE, Type.SET),
    REWARD_CREATE(BaseEditType.ADD, Type.REWARD),
    REWARD_CHANGE(BaseEditType.CHANGE, Type.REWARD),
    REWARD_REMOVE(BaseEditType.REMOVE, Type.REWARD),
    MONSTER_CREATE(BaseEditType.ADD, Type.MONSTER),
    MONSTER_CHANGE(BaseEditType.CHANGE, Type.MONSTER),
    MONSTER_REMOVE(BaseEditType.REMOVE, Type.MONSTER),
    LOCATION_CREATE(BaseEditType.ADD, Type.LOCATION),
    LOCATION_CHANGE(BaseEditType.CHANGE, Type.LOCATION),
    LOCATION_REMOVE(BaseEditType.REMOVE, Type.LOCATION),
    ADVANCEMENT_CREATE(BaseEditType.ADD, Type.ADVANCEMENT),
    ADVANCEMENT_CHANGE(BaseEditType.CHANGE, Type.ADVANCEMENT),
    ADVANCEMENT_REMOVE(BaseEditType.REMOVE, Type.ADVANCEMENT),
    COMPLETE_CHECK_CREATE(BaseEditType.ADD, Type.COMPLETION),
    COMPLETE_CHECK_CHANGE(BaseEditType.CHANGE, Type.COMPLETION),
    COMPLETE_CHECK_REMOVE(BaseEditType.REMOVE, Type.COMPLETION),
    TIER_CREATE(BaseEditType.ADD, Type.TIER),
    TIER_CHANGE(BaseEditType.CHANGE, Type.TIER),
    TIER_REMOVE(BaseEditType.REMOVE, Type.TIER),
    GROUP_CREATE(BaseEditType.ADD, Type.GROUP),
    GROUP_CHANGE(BaseEditType.CHANGE, Type.GROUP),
    GROUP_REMOVE(BaseEditType.REMOVE, Type.GROUP),
    GROUP_ITEM_CREATE(BaseEditType.ADD, Type.GROUP_ITEM),
    GROUP_ITEM_CHANGE(BaseEditType.REMOVE, Type.GROUP_ITEM),
    GROUP_ITEM_REMOVE(BaseEditType.REMOVE, Type.GROUP_ITEM),
    DEATH_CHANGE(BaseEditType.CHANGE, Type.DEATH),
    TASK_ITEM_CREATE(BaseEditType.ADD, Type.TASK_ITEM),
    TASK_ITEM_CHANGE(BaseEditType.CHANGE, Type.TASK_ITEM),
    TASK_ITEM_REMOVE(BaseEditType.REMOVE, Type.TASK_ITEM),
    REPUTATION_ADD(BaseEditType.ADD, Type.REPUTATION),
    REPUTATION_REMOVE(BaseEditType.REMOVE, Type.REPUTATION),
    REPUTATION_MARKER_CREATE(BaseEditType.ADD, Type.REPUTATION_MARKER),
    REPUTATION_MARKER_CHANGE(BaseEditType.CHANGE, Type.REPUTATION_MARKER),
    REPUTATION_MARKER_REMOVE(BaseEditType.REMOVE, Type.REPUTATION_MARKER),
    REPUTATION_TASK_CREATE(BaseEditType.ADD, Type.REPUTATION_TASK),
    REPUTATION_TASK_CHANGE(BaseEditType.CHANGE, Type.REPUTATION_TASK),
    REPUTATION_TASK_REMOVE(BaseEditType.REMOVE, Type.REPUTATION_TASK),
    REPUTATION_REWARD_CHANGE(BaseEditType.CHANGE, Type.REPUTATION_REWARD),
    KILLS_CHANGE(BaseEditType.CHANGE, Type.KILLS),
    REPUTATION_BAR_ADD(BaseEditType.ADD, Type.REPUTATION_BAR),
    REPUTATION_BAR_MOVE(BaseEditType.MOVE, Type.REPUTATION_BAR),
    REPUTATION_BAR_CHANGE(BaseEditType.CHANGE, Type.REPUTATION_BAR),
    REPUTATION_BAR_REMOVE(BaseEditType.REMOVE, Type.REPUTATION_BAR),
    COMMAND_ADD(BaseEditType.ADD, Type.COMMAND),
    COMMAND_CHANGE(BaseEditType.CHANGE, Type.COMMAND),
    COMMAND_REMOVE(BaseEditType.REMOVE, Type.COMMAND);

    private final BaseEditType basType;
    private final Type type;

    private EditType(BaseEditType basType, Type type) {
        this.basType = basType;
        this.type = type;
    }

    public FormattedText translate(int number) {
        return this.basType.translate().m_130946_(" ").m_7220_((Component)this.type.translate()).m_130946_(": ").m_7220_((Component)Translator.text(String.valueOf(number)).m_130940_(this.basType.colour));
    }

    public static enum BaseEditType {
        ADD("added", ChatFormatting.DARK_GREEN),
        CHANGE("changed", ChatFormatting.GOLD),
        MOVE("moved", ChatFormatting.GOLD),
        REMOVE("removed", ChatFormatting.DARK_RED);

        private final String id;
        private final ChatFormatting colour;

        private BaseEditType(String id, ChatFormatting colour) {
            this.id = id;
            this.colour = colour;
        }

        public EditType with(Type type) {
            for (EditType editType : EditType.values()) {
                if (this != editType.basType || editType.type != type) continue;
                return editType;
            }
            throw new IllegalArgumentException("Type " + type + " does not have a base type " + this);
        }

        private MutableComponent translate() {
            return Translator.translatable("hqm.editType." + this.id, new Object[0]);
        }
    }

    public static enum Type {
        QUEST("quest"),
        TASK("task"),
        TASK_TYPE("taskType"),
        REQUIREMENT("req"),
        REPEATABILITY("repeat"),
        VISIBILITY("vis"),
        PARENT("parent"),
        OPTION("option"),
        NAME("name"),
        DESCRIPTION("desc"),
        ICON("icon"),
        QUEST_SIZE("questSize"),
        SET("set"),
        REWARD("reward"),
        MONSTER("monster"),
        LOCATION("location"),
        TIER("tier"),
        GROUP("group"),
        GROUP_ITEM("groupItem"),
        DEATH("death"),
        TASK_ITEM("taskItem"),
        REPUTATION("rep"),
        REPUTATION_MARKER("repMark"),
        REPUTATION_TASK("repTask"),
        REPUTATION_REWARD("repReward"),
        KILLS("kills"),
        REPUTATION_BAR("repBar"),
        BETWEEN_SETS("betweenSets"),
        COMMAND("command"),
        ADVANCEMENT("advancement"),
        COMPLETION("questCompletion"),
        TASK_BLOCK("taskBlock");

        private final String id;

        private Type(String id) {
            this.id = id;
        }

        private MutableComponent translate() {
            return Translator.translatable("hqm.editType." + this.id, new Object[0]);
        }
    }
}

