/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.util;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.architectury.fluid.FluidStack;
import hardcorequesting.common.forge.util.Fraction;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FluidUtils {
    public static FluidStack split(FluidStack fluid, Fraction toRemove) {
        if (toRemove.isLessThan(Fraction.empty())) {
            throw new IllegalArgumentException("Cannot split off a negative amount!");
        }
        if (toRemove.equals(Fraction.empty()) || fluid.isEmpty()) {
            return FluidStack.empty();
        }
        if (toRemove.isGreaterThan(FluidUtils.getAmount(fluid))) {
            toRemove = FluidUtils.getAmount(fluid);
        }
        return FluidUtils.performSplit(fluid, toRemove);
    }

    public static FluidStack performSplit(FluidStack stack, Fraction toTake) {
        stack.setAmount((long)FluidUtils.getAmount(stack).minus(toTake).intValue());
        return FluidStack.create((FluidStack)stack, (long)toTake.intValue());
    }

    public static Fraction getAmount(FluidStack stack) {
        return Fraction.ofWhole(stack.getAmount());
    }

    public static Material getBlockMaterial(ResourceLocation loc) {
        return new Material(TextureAtlas.f_118259_, loc);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CustomRenderTypes
    extends RenderType {
        private CustomRenderTypes(String string, VertexFormat arg, VertexFormat.Mode arg2, int i, boolean bl, boolean bl2, Runnable runnable, Runnable runnable2) {
            super(string, arg, arg2, i, bl, bl2, runnable, runnable2);
            throw new IllegalStateException("This class is not meant to be constructed!");
        }

        public static RenderType createFluid(ResourceLocation location) {
            return RenderType.m_173215_((String)"hardcorequesting:fluid_type", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173101_).m_110671_(RenderStateShard.f_110152_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(location, false, false)).m_110685_(RenderStateShard.f_110139_).m_110691_(false));
        }
    }
}

