/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.network.IMessage;
import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.network.message.OpActionMessage;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestingData;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.quests.task.item.ItemRequirementTask;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;

public final class OPBookHelper {
    private OPBookHelper() {
    }

    public static void reverseQuestCompletion(Quest quest, UUID subject) {
        NetworkManager.sendToServer(OpAction.QUEST_COMPLETION.build(quest, null, -1, subject));
    }

    public static void reverseTaskCompletion(QuestTask<?> task, UUID subject) {
        NetworkManager.sendToServer(OpAction.TASK_COMPLETION.build(task.getParent(), task, -1, subject));
    }

    public static void reverseRequirementCompletion(QuestTask<?> task, int requirement, UUID subject) {
        NetworkManager.sendToServer(OpAction.REQUIREMENT_COMPLETION.build(task.getParent(), task, requirement, subject));
    }

    public static void reset(UUID player) {
        NetworkManager.sendToServer(OpAction.RESET.build(null, null, -1, player));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum OpAction {
        RESET{

            @Override
            public void process(String data) {
                this.fromJson(data);
                QuestingDataManager.getInstance().getQuestingData(this.subject).getTeam().clearProgress();
            }
        }
        ,
        QUEST_COMPLETION{

            @Override
            public void process(String data) {
                this.fromJson(data);
                if (this.quest != null) {
                    if (this.quest.isCompleted(this.subject)) {
                        QuestingDataManager.getInstance().getQuestingData(this.subject).getTeam().resetProgress(this.quest);
                    } else {
                        this.quest.completeQuest(this.subject);
                    }
                    this.quest.sendUpdatedDataToTeam(this.subject);
                }
            }
        }
        ,
        TASK_COMPLETION{

            @Override
            public void process(String data) {
                this.fromJson(data);
                if (this.quest == null) {
                    return;
                }
                if (this.task != null) {
                    if (this.task.isCompleted(this.subject)) {
                        this.task.resetData(this.subject.m_20148_());
                        QuestingDataManager.getInstance().getQuestingData(this.subject).getTeam().resetCompletion(this.quest);
                    } else {
                        this.task.completeTask(this.subject.m_20148_());
                    }
                }
                this.quest.sendUpdatedDataToTeam(this.subject);
            }
        }
        ,
        REQUIREMENT_COMPLETION{

            @Override
            public void process(String data) {
                this.fromJson(data);
                if (this.quest == null || this.task == null) {
                    return;
                }
                if (this.task instanceof ItemRequirementTask) {
                    ItemRequirementTask itemTask = (ItemRequirementTask)this.task;
                    itemTask.switchPartStatus(this.requirement, this.subject.m_20148_());
                }
            }
        };

        private static final String QUEST = "quest";
        private static final String SUBJECT = "subject";
        private static final String TASK = "task";
        private static final String REQUIREMENT = "requirement";
        protected int requirement;
        protected Quest quest;
        protected Player subject;
        protected QuestTask task;

        private static String toJson(Quest quest, QuestTask task, int requirement, UUID subject) {
            StringWriter stringWriter = new StringWriter();
            try {
                JsonWriter writer = new JsonWriter((Writer)stringWriter);
                writer.beginObject();
                if (quest != null) {
                    writer.name(QUEST).value(quest.getQuestId().toString());
                }
                if (subject != null) {
                    writer.name(SUBJECT).value(subject.toString());
                }
                if (task != null) {
                    writer.name(TASK).value((long)task.getId());
                }
                if (requirement != -1) {
                    writer.name(REQUIREMENT).value((long)requirement);
                }
                writer.endObject();
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return stringWriter.toString();
        }

        public abstract void process(String var1);

        public IMessage build(Quest quest, QuestTask task, int requirement, UUID subject) {
            return new OpActionMessage(this, OpAction.toJson(quest, task, requirement, subject));
        }

        public void process(Player player, String data) {
            if (HardcoreQuestingCore.getServer().m_129944_(player.m_36316_()) >= 4) {
                this.process(data);
            }
        }

        protected void fromJson(String data) {
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse(data).getAsJsonObject();
            if (root.has(QUEST)) {
                this.quest = Quest.getQuest(UUID.fromString(root.get(QUEST).getAsString()));
            }
            if (root.has(SUBJECT)) {
                this.subject = QuestingData.getPlayer(root.get(SUBJECT).getAsString());
            }
            if (root.has(TASK) && this.quest != null) {
                this.task = this.quest.getTasks().get(root.get(TASK).getAsInt());
            }
            if (root.has(REQUIREMENT) && this.quest != null && this.task != null) {
                this.requirement = root.get(REQUIREMENT).getAsInt();
            }
        }
    }
}

