/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.util;

import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class SaveHelper {
    private static final int START_X = 5;
    private static final int START_Y = 30;
    private static final int INDENT = 5;
    private static final int FONT_HEIGHT = 7;
    private static final int LISTED_TYPES = 7;
    private static final int X = 342;
    private static final int Y = 5;
    private static final int SRC_X = 0;
    private static final int SRC_Y = 123;
    private static final int WIDTH = 104;
    private static final int HEIGHT = 110;
    private static final int CHANGE_X = 4;
    private static final int CHANGE_Y = 4;
    private static final int CHANGE_SIZE = 7;
    private static final int CHANGE_SRC_X = 104;
    private static final int SMALL_SRC_X = 104;
    private static final int SMALL_SRC_Y = 137;
    private static final int SMALL_SIZE = 29;
    private static final int SAVE_X = 11;
    private static final int SAVE_Y = 11;
    private static final int SAVE_SRC_X = 118;
    private static final int SAVE_SIZE = 14;
    private static boolean isLarge = true;
    private static long saveTime;
    private static int total;
    public static ListElement[] list;
    private static List<ListElement> sortedList;

    private SaveHelper() {
    }

    private static void createList() {
        list = new ListElement[EditType.values().length];
        for (int i = 0; i < list.length; ++i) {
            SaveHelper.list[i] = new ListElement(EditType.values()[i]);
        }
        sortedList = new ArrayList<ListElement>();
        Collections.addAll(sortedList, list);
        Collections.sort(sortedList);
        total = 0;
    }

    public static void add(EditType type, int count) {
        SaveHelper.list[type.ordinal()].count += count;
        Collections.sort(sortedList);
        total += count;
    }

    public static void add(EditType type) {
        SaveHelper.add(type, 1);
    }

    public static void onSave() {
        saveTime = System.currentTimeMillis();
        SaveHelper.createList();
    }

    public static void onLoad() {
        SaveHelper.createList();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void render(GuiGraphics graphics, GuiQuestBook gui, int mX, int mY) {
        if (isLarge) {
            gui.drawRect(graphics, GuiBase.MAP_TEXTURE, 342, 5, 0, 123, 104, 110);
        } else {
            gui.drawRect(graphics, GuiBase.MAP_TEXTURE, 342, 5, 104, 137, 29, 29);
        }
        int indexX = isLarge ? 0 : 1;
        int indexY = gui.inBounds(346, 9, 7, 7, mX, mY) ? 1 : 0;
        gui.drawRect(graphics, GuiBase.MAP_TEXTURE, 346, 9, 104 + indexX * 7, 123 + indexY * 7, 7, 7);
        if (isLarge) {
            if (total == 0) {
                gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.editType.allSaved", new Object[0]), 347, 35, 0.7f, 0x404040);
            } else {
                if (saveTime == 0L) {
                    gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.editType.neverSaved", new Object[0]), 347, 35, 0.7f, 0x404040);
                } else {
                    gui.drawString(graphics, SaveHelper.formatTime((int)((System.currentTimeMillis() - saveTime) / 60000L)), 347, 35, 0.7f, 0x404040);
                }
                gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.editType.unsaved", total), 347, 49, 0.7f, 0x404040);
                int others = total;
                for (int i = 0; i < 7; ++i) {
                    ListElement element = sortedList.get(i);
                    if (element.count == 0) break;
                    gui.drawString(graphics, element.type.translate(element.count), 352, 35 + (i + 3) * 7, 0.7f, 0x404040);
                    others -= element.count;
                }
                if (others > 0) {
                    gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.editType.other", others), 352, 105, 0.7f, 0x404040);
                }
            }
        } else {
            int index = SaveHelper.inSaveBounds(gui, mX, mY) ? 1 : 0;
            gui.drawRect(graphics, GuiBase.MAP_TEXTURE, 353, 16, 118 + index * 14, 123, 14, 14);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onClick(GuiQuestBook gui, int mX, int mY) {
        if (gui.inBounds(346, 9, 7, 7, mX, mY)) {
            isLarge = !isLarge;
        } else if (SaveHelper.inSaveBounds(gui, mX, mY)) {
            gui.save();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean inSaveBounds(GuiQuestBook gui, int mX, int mY) {
        return !isLarge && gui.inBounds(353, 16, 14, 14, mX, mY);
    }

    private static FormattedText formatTime(int minutes) {
        int hours = minutes / 60;
        minutes -= hours * 60;
        if (hours == 0) {
            if (minutes == 0) {
                return Translator.translatable("hqm.editType.savedRecent", new Object[0]);
            }
            return Translator.translatable("hqm.editType.savedTime", Translator.plural("hqm.minute", minutes));
        }
        return Translator.translatable("hqm.editType.savedTime", Translator.plural("hqm.hour", hours));
    }

    public static boolean isLarge() {
        return isLarge;
    }

    static {
        SaveHelper.createList();
    }

    public static class ListElement
    implements Comparable<ListElement> {
        private EditType type;
        public int count;

        private ListElement(EditType type) {
            this.type = type;
            this.count = 0;
        }

        @Override
        public int compareTo(ListElement o) {
            return Integer.compare(o.count, this.count);
        }
    }
}

