/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.util;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;

public class SyncUtil {
    private static int splitCount = 3000;

    public static int getSplitCount() {
        return splitCount;
    }

    public static void setSplitCount(int count) {
        splitCount = count;
    }

    public static List<String> splitData(String input, int splitSize) {
        ArrayList<String> output = new ArrayList<String>();
        int len = input.length();
        for (int i = 0; i < len; i += splitSize) {
            output.add(input.substring(i, Math.min(len, i + splitSize)));
        }
        return output;
    }

    public static String joinData(List<String> input) {
        return SyncUtil.joinData(input, "");
    }

    public static String joinData(List<String> input, String joiner) {
        return String.join((CharSequence)joiner, input);
    }

    public static void reconstructString(List<String> data, ByteBuf buf) {
        data.clear();
        int count = buf.readInt();
        FriendlyByteBuf packetByteBuf = new FriendlyByteBuf(buf);
        for (int i = 0; i < count; ++i) {
            data.add(packetByteBuf.m_130136_(Short.MAX_VALUE));
        }
    }

    public static List<String> reconstructString(ByteBuf buf) {
        ArrayList<String> data = new ArrayList<String>();
        SyncUtil.reconstructString(data, buf);
        return data;
    }

    public static void deconstructString(List<String> input, ByteBuf output) {
        output.writeInt(input.size());
        FriendlyByteBuf packetByteBuf = new FriendlyByteBuf(output);
        for (String chunk : input) {
            packetByteBuf.m_130070_(chunk);
        }
    }

    public static void writeLargeString(String input, ByteBuf output) {
        List<String> data = SyncUtil.splitData(input, SyncUtil.getSplitCount());
        SyncUtil.deconstructString(data, output);
    }

    public static String readLargeString(ByteBuf input) {
        return SyncUtil.joinData(SyncUtil.reconstructString(input));
    }
}

