/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hardcorequesting.common.forge.util.Translator;
import java.util.Objects;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.GsonHelper;

public final class WrappedText {
    private static final String TEXT = "text";
    private static final String TRANSLATED = "isTranslationKey";
    private final String text;
    private final boolean shouldTranslate;

    public static WrappedText create(String text) {
        return new WrappedText(text, false);
    }

    public static WrappedText createTranslated(String key) {
        return new WrappedText(key, true);
    }

    public static WrappedText fromJson(JsonElement element, String fallback, boolean isDefaultTranslated) {
        if (element == null) {
            return new WrappedText(fallback, isDefaultTranslated);
        }
        return WrappedText.fromJson(element, isDefaultTranslated);
    }

    public static WrappedText fromJson(JsonElement element, boolean isDefaultTranslated) {
        if (GsonHelper.m_13803_((JsonElement)element)) {
            return new WrappedText(element.getAsString(), isDefaultTranslated);
        }
        JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)"wrapped text");
        return new WrappedText(GsonHelper.m_13906_((JsonObject)json, (String)TEXT), GsonHelper.m_13912_((JsonObject)json, (String)TRANSLATED));
    }

    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.addProperty(TEXT, this.text);
        json.addProperty(TRANSLATED, Boolean.valueOf(this.shouldTranslate));
        return json;
    }

    private WrappedText(String text, boolean shouldTranslate) {
        this.text = Objects.requireNonNull(text);
        this.shouldTranslate = shouldTranslate;
    }

    public MutableComponent getText() {
        if (this.shouldTranslate) {
            return Translator.translatable(this.text, new Object[0]);
        }
        return Translator.text(this.text);
    }

    public String getRawText() {
        return this.text;
    }

    public boolean shouldTranslate() {
        return this.shouldTranslate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WrappedText that = (WrappedText)o;
        return this.shouldTranslate == that.shouldTranslate && this.text.equals(that.text);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.shouldTranslate);
    }
}

