/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.forge;

import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.platform.forge.EventBuses;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.config.HQMConfig;
import hardcorequesting.common.forge.items.ModItems;
import hardcorequesting.common.forge.platform.AbstractPlatform;
import hardcorequesting.common.forge.platform.NetworkManager;
import hardcorequesting.common.forge.recipe.BookCatalystRecipeSerializer;
import hardcorequesting.common.forge.tileentity.AbstractBarrelBlockEntity;
import hardcorequesting.common.forge.util.Fraction;
import hardcorequesting.forge.NetworkingManager;
import hardcorequesting.forge.tileentity.BarrelBlockEntity;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;

@Mod(value="hardcorequesting")
public class HardcoreQuestingForge
implements AbstractPlatform {
    private final NetworkManager networkManager = new NetworkingManager();
    private final DeferredRegister<SoundEvent> sounds = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"hardcorequesting");
    private final DeferredRegister<CreativeModeTab> tab = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"hardcorequesting");
    private final DeferredRegister<Block> block = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"hardcorequesting");
    private final DeferredRegister<Item> item = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"hardcorequesting");
    private final DeferredRegister<RecipeSerializer<?>> recipe = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"hardcorequesting");
    private final DeferredRegister<BlockEntityType<?>> tileEntityType = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"hardcorequesting");

    public HardcoreQuestingForge() {
        EventBuses.registerModEventBus((String)"hardcorequesting", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        NetworkingManager.init();
        HardcoreQuestingCore.initialize(this);
        this.sounds.register(FMLJavaModLoadingContext.get().getModEventBus());
        this.tab.register(FMLJavaModLoadingContext.get().getModEventBus());
        this.block.register(FMLJavaModLoadingContext.get().getModEventBus());
        this.item.register(FMLJavaModLoadingContext.get().getModEventBus());
        this.recipe.register(FMLJavaModLoadingContext.get().getModEventBus());
        this.tileEntityType.register(FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.addListener(event -> {
            LivingEntity patt5592$temp = event.getEntity();
            if (patt5592$temp instanceof Player) {
                Player player = (Player)patt5592$temp;
                if (player instanceof FakePlayer || event.isCanceled() || player.m_9236_().m_46469_().m_46207_(GameRules.f_46133_) || HQMConfig.getInstance().LOSE_QUEST_BOOK) {
                    return;
                }
                Iterator iter = event.getDrops().iterator();
                while (iter.hasNext()) {
                    ItemEntity entityItem = (ItemEntity)iter.next();
                    ItemStack stack = entityItem.m_32055_();
                    if (!stack.m_150930_((Item)ModItems.book.get())) continue;
                    player.m_150109_().m_36054_(stack);
                    iter.remove();
                }
            }
        });
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.getEntity() == null || event.getEntity() instanceof FakePlayer || !event.isWasDeath() || event.isCanceled() || event.getEntity().m_9236_().m_46469_().m_46207_(GameRules.f_46133_) || HQMConfig.getInstance().LOSE_QUEST_BOOK) {
                return;
            }
            ItemStack bookStack = new ItemStack((ItemLike)ModItems.book.get());
            if (event.getOriginal().m_150109_().m_36063_(bookStack)) {
                for (ItemStack stack : event.getOriginal().m_150109_().f_35974_) {
                    if (!ItemStack.m_41656_((ItemStack)bookStack, (ItemStack)stack)) continue;
                    bookStack = stack.m_41777_();
                    break;
                }
                event.getEntity().m_150109_().m_36054_(bookStack);
            }
        });
    }

    @Override
    public Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public NetworkManager getNetworkManager() {
        return this.networkManager;
    }

    @Override
    public MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    @Override
    public String getModVersion() {
        return ((ModContainer)ModList.get().getModContainerById("hardcorequesting").get()).getModInfo().getVersion().toString();
    }

    @Override
    public boolean isClient() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }

    @Override
    public void registerOnCommandRegistration(Consumer<CommandDispatcher<CommandSourceStack>> consumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> consumer.accept(event.getDispatcher()));
    }

    @Override
    public void registerOnWorldLoad(BiConsumer<ResourceKey<Level>, ServerLevel> biConsumer) {
        MinecraftForge.EVENT_BUS.addListener(load -> {
            if (load.getLevel() instanceof ServerLevel) {
                biConsumer.accept(((Level)load.getLevel()).m_46472_(), (ServerLevel)load.getLevel());
            }
        });
    }

    @Override
    public void registerOnWorldSave(Consumer<ServerLevel> consumer) {
        MinecraftForge.EVENT_BUS.addListener(save -> {
            if (save.getLevel() instanceof ServerLevel) {
                consumer.accept((ServerLevel)save.getLevel());
            }
        });
    }

    @Override
    public void registerOnPlayerJoin(Consumer<ServerPlayer> consumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> consumer.accept((ServerPlayer)event.getEntity()));
    }

    @Override
    public void registerOnServerTick(Consumer<MinecraftServer> consumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.phase == TickEvent.Phase.END) {
                consumer.accept(this.getServer());
            }
        });
    }

    @Override
    public void registerOnClientTick(Consumer<Minecraft> consumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.phase == TickEvent.Phase.END) {
                consumer.accept(Minecraft.m_91087_());
            }
        });
    }

    @Override
    public void registerOnWorldTick(Consumer<Level> consumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.phase == TickEvent.Phase.END) {
                consumer.accept(event.level);
            }
        });
    }

    @Override
    public void registerOnUseItem(TriConsumer<Player, Level, InteractionHand> triConsumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> triConsumer.accept((Object)event.getEntity(), (Object)event.getLevel(), (Object)event.getHand()));
    }

    @Override
    public void registerOnBlockPlace(AbstractPlatform.BlockPlaced blockPlaced) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.getEntity() instanceof LivingEntity) {
                blockPlaced.onBlockPlaced(event.getEntity().m_20193_(), event.getPos(), event.getPlacedBlock(), (LivingEntity)event.getEntity());
            }
        });
    }

    @Override
    public void registerOnBlockUse(AbstractPlatform.BlockUsed blockUsed) {
        MinecraftForge.EVENT_BUS.addListener(event -> blockUsed.onBlockUsed(event.getEntity(), event.getLevel(), event.getHand(), event.getPos(), event.getFace()));
    }

    @Override
    public void registerOnBlockBreak(AbstractPlatform.BlockBroken blockBroken) {
        MinecraftForge.EVENT_BUS.addListener(event -> blockBroken.onBlockBroken(event.getLevel(), event.getPos(), event.getState(), event.getPlayer()));
    }

    @Override
    public void registerOnItemPickup(BiConsumer<Player, ItemStack> biConsumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> biConsumer.accept(event.getEntity(), event.getStack()));
    }

    @Override
    public void registerOnLivingDeath(BiConsumer<LivingEntity, DamageSource> biConsumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> biConsumer.accept(event.getEntity(), event.getSource()));
    }

    @Override
    public void registerOnCrafting(BiConsumer<Player, ItemStack> triConsumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> triConsumer.accept(event.getEntity(), event.getCrafting()));
    }

    @Override
    public void registerOnAnvilCrafting(BiConsumer<Player, ItemStack> triConsumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> triConsumer.accept(event.getEntity(), event.getOutput()));
    }

    @Override
    public void registerOnSmelting(BiConsumer<Player, ItemStack> triConsumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> triConsumer.accept(event.getEntity(), event.getSmelting()));
    }

    @Override
    public void registerOnAdvancement(BiConsumer<ServerPlayer, Advancement> biConsumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.getEntity() instanceof ServerPlayer) {
                biConsumer.accept((ServerPlayer)event.getEntity(), event.getAdvancement());
            }
        });
    }

    @Override
    public void registerOnAnimalTame(BiConsumer<Player, Entity> biConsumer) {
        MinecraftForge.EVENT_BUS.addListener(event -> biConsumer.accept(event.getTamer(), (Entity)event.getAnimal()));
    }

    @Override
    public CompoundTag getPlayerExtraTag(Player playerEntity) {
        return playerEntity.getPersistentData();
    }

    @Override
    public AbstractBarrelBlockEntity createBarrelBlockEntity(BlockPos pos, BlockState state) {
        return new BarrelBlockEntity(pos, state);
    }

    @Override
    public List<dev.architectury.fluid.FluidStack> findFluidsIn(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(HardcoreQuestingForge::getAllFluidsIn).orElse(Collections.emptyList());
    }

    @NotNull
    private static List<dev.architectury.fluid.FluidStack> getAllFluidsIn(IFluidHandlerItem handler) {
        ArrayList<dev.architectury.fluid.FluidStack> fluids = new ArrayList<dev.architectury.fluid.FluidStack>();
        for (int tank = 0; tank < handler.getTanks(); ++tank) {
            FluidStack fluid = handler.getFluidInTank(tank);
            if (fluid.isEmpty()) continue;
            fluids.add(dev.architectury.fluid.FluidStack.create((Fluid)fluid.getFluid(), (long)fluid.getAmount()));
        }
        return fluids;
    }

    @Override
    public Fraction getBucketAmount() {
        return Fraction.ofWhole(1000L);
    }

    @Override
    public <T extends Block> Supplier<T> registerBlock(String id, Supplier<T> supplier) {
        return this.block.register(id, supplier);
    }

    @Override
    public Supplier<SoundEvent> registerSound(String id, Supplier<SoundEvent> supplier) {
        return this.sounds.register(id, supplier);
    }

    @Override
    public <T extends Item> Supplier<T> registerItem(String id, Supplier<T> supplier) {
        return this.item.register(id, supplier);
    }

    @Override
    public <T extends BlockEntity> Supplier<BlockEntityType<T>> registerBlockEntity(String id, BiFunction<BlockPos, BlockState, T> constructor, Supplier<Block> validBlock) {
        return this.tileEntityType.register(id, () -> BlockEntityType.Builder.m_155273_(constructor::apply, (Block[])new Block[]{(Block)validBlock.get()}).m_58966_(null));
    }

    @Override
    public Supplier<RecipeSerializer<?>> registerBookRecipeSerializer(String id) {
        return this.recipe.register(id, BookCatalystRecipeSerializer::new);
    }

    @Override
    public Supplier<CreativeModeTab> registerTab(String id, Supplier<CreativeModeTab> supplier) {
        return this.tab.register(id, supplier);
    }
}

