/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.forge.tileentity;

import dev.architectury.fluid.FluidStack;
import hardcorequesting.common.forge.quests.data.ItemsTaskData;
import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.quests.task.item.ConsumeItemTask;
import hardcorequesting.common.forge.tileentity.AbstractBarrelBlockEntity;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BarrelBlockEntity
extends AbstractBarrelBlockEntity {
    private final LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        @NotNull
        public net.minecraftforge.fluids.FluidStack getFluidInTank(int tank) {
            return net.minecraftforge.fluids.FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, @NotNull net.minecraftforge.fluids.FluidStack stack) {
            QuestTask<?> task = BarrelBlockEntity.this.getCurrentTask();
            if (task instanceof ConsumeItemTask) {
                ConsumeItemTask consumeTask = (ConsumeItemTask)task;
                UUID playerUUID = BarrelBlockEntity.this.getPlayerUUID();
                return consumeTask.canTakeFluid(stack.getFluid(), playerUUID);
            }
            return false;
        }

        public int fill(net.minecraftforge.fluids.FluidStack resource, IFluidHandler.FluidAction action) {
            QuestTask<?> task = BarrelBlockEntity.this.getCurrentTask();
            if (task instanceof ConsumeItemTask) {
                ConsumeItemTask consumeItemTask = (ConsumeItemTask)task;
                UUID playerUUID = BarrelBlockEntity.this.getPlayerUUID();
                net.minecraftforge.fluids.FluidStack duplicate = resource.copy();
                if (consumeItemTask.increaseFluid(FluidStack.create((Fluid)duplicate.getFluid(), (long)duplicate.getAmount()), playerUUID, action.execute()) && action.execute()) {
                    ItemsTaskData data = (ItemsTaskData)consumeItemTask.getData(BarrelBlockEntity.this.getPlayerUUID());
                    consumeItemTask.doCompletionCheck(data, BarrelBlockEntity.this.getPlayerUUID());
                    BarrelBlockEntity.this.updateState();
                    BarrelBlockEntity.this.doSync();
                }
                return resource.getAmount() - duplicate.getAmount();
            }
            return 0;
        }

        @NotNull
        public net.minecraftforge.fluids.FluidStack drain(net.minecraftforge.fluids.FluidStack resource, IFluidHandler.FluidAction action) {
            return net.minecraftforge.fluids.FluidStack.EMPTY;
        }

        @NotNull
        public net.minecraftforge.fluids.FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return net.minecraftforge.fluids.FluidStack.EMPTY;
        }
    });

    public BarrelBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }
}

