/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.betterend;

import com.simibubi.create.Create;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.portal.PortalInfo;

public class BetterEndPortalCompat {
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private static MethodHandle constructorHandle;
    private static VarHandle portalEntrancePosHandle;
    private static MethodHandle findDimensionEntryPointHandle;
    private static boolean hasErrored;

    public static PortalInfo getBetterEndPortalInfo(ServerLevel targetLevel, Entity entity) {
        if (!hasErrored) {
            try {
                Object travelerState = constructorHandle.invoke(entity);
                portalEntrancePosHandle.set(travelerState, entity.m_20183_().m_7949_());
                return findDimensionEntryPointHandle.invoke(travelerState, targetLevel);
            }
            catch (Throwable e) {
                Create.LOGGER.error("Create's Better End Portal compat failed to initialize: ", e);
            }
        }
        return null;
    }

    static {
        hasErrored = false;
        try {
            Class<?> travelerStateClass = Class.forName("org.betterx.betterend.portal.TravelerState");
            MethodHandles.Lookup privateLookup = MethodHandles.privateLookupIn(travelerStateClass, lookup);
            MethodType travelerStateConstructorTypes = MethodType.methodType(Void.TYPE, Entity.class);
            constructorHandle = lookup.findConstructor(travelerStateClass, travelerStateConstructorTypes);
            portalEntrancePosHandle = privateLookup.findVarHandle(travelerStateClass, "portalEntrancePos", BlockPos.class);
            MethodType findDimensionEntryPointTypes = MethodType.methodType(PortalInfo.class, ServerLevel.class);
            findDimensionEntryPointHandle = privateLookup.findVirtual(travelerStateClass, "findDimensionEntryPoint", findDimensionEntryPointTypes);
        }
        catch (Exception e) {
            Create.LOGGER.error("Create's Better End Portal compat failed to initialize: ", (Throwable)e);
            hasErrored = true;
        }
    }
}

