/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute.attributes;

import com.simibubi.create.content.logistics.item.filter.attribute.AllItemAttributeTypes;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidContentsAttribute
implements ItemAttribute {
    @Nullable
    private Fluid fluid;

    public FluidContentsAttribute(@Nullable Fluid fluid) {
        this.fluid = fluid;
    }

    private static List<Fluid> extractFluids(ItemStack stack) {
        ArrayList<Fluid> fluids = new ArrayList<Fluid>();
        LazyOptional capability = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
        capability.ifPresent(cap -> {
            for (int i = 0; i < cap.getTanks(); ++i) {
                fluids.add(cap.getFluidInTank(i).getFluid());
            }
        });
        return fluids;
    }

    @Override
    public boolean appliesTo(ItemStack itemStack, Level level) {
        return FluidContentsAttribute.extractFluids(itemStack).contains(this.fluid);
    }

    @Override
    public String getTranslationKey() {
        return "has_fluid";
    }

    @Override
    public Object[] getTranslationParameters() {
        String parameter = "";
        if (this.fluid != null) {
            parameter = this.fluid.getFluidType().getDescription().getString();
        }
        return new Object[]{parameter};
    }

    @Override
    public ItemAttributeType getType() {
        return AllItemAttributeTypes.HAS_FLUID;
    }

    @Override
    public void save(CompoundTag nbt) {
        if (this.fluid == null) {
            return;
        }
        ResourceLocation id = ForgeRegistries.FLUIDS.getKey((Object)this.fluid);
        if (id == null) {
            return;
        }
        nbt.m_128359_("fluidId", id.toString());
    }

    @Override
    public void load(CompoundTag nbt) {
        if (nbt.m_128441_("fluidId")) {
            this.fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(ResourceLocation.m_135820_((String)nbt.m_128461_("fluidId")));
        }
    }

    public static class Type
    implements ItemAttributeType {
        @Override
        @NotNull
        public ItemAttribute createAttribute() {
            return new FluidContentsAttribute(null);
        }

        @Override
        public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
            ArrayList<ItemAttribute> list = new ArrayList<ItemAttribute>();
            for (Fluid fluid : FluidContentsAttribute.extractFluids(stack)) {
                list.add(new FluidContentsAttribute(fluid));
            }
            return list;
        }
    }
}

