/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.tableCloth;

import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.tableCloth.TableClothBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.IntAttached;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class ShoppingListItem
extends Item {
    public ShoppingListItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public static ShoppingList getList(ItemStack stack) {
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_("ShoppingList")) {
            return null;
        }
        return ShoppingList.load(stack.m_41783_().m_128469_("ShoppingList"));
    }

    public static ItemStack saveList(ItemStack stack, ShoppingList list, String address) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_("ShoppingList", (Tag)list.save());
        tag.m_128359_("Address", address);
        return stack;
    }

    public static String getAddress(ItemStack stack) {
        if (!stack.m_41782_()) {
            return "";
        }
        return stack.m_41783_().m_128461_("Address");
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        Couple<InventorySummary> lists;
        ShoppingList list = ShoppingListItem.getList(pStack);
        if (list != null && (lists = list.bakeEntries((LevelAccessor)pLevel, null)) != null) {
            for (InventorySummary items : lists) {
                boolean cost;
                List<BigItemStack> entries = items.getStacksByCount();
                boolean bl = cost = items == lists.getSecond();
                if (cost) {
                    pTooltipComponents.add((Component)Component.m_237119_());
                }
                if (entries.size() == 1) {
                    BigItemStack entry = entries.get(0);
                    (cost ? CreateLang.translate("table_cloth.total_cost", new Object[0]) : CreateLang.text("")).style(ChatFormatting.GOLD).add(CreateLang.builder().add(entry.stack.m_41786_()).text(" x").text(String.valueOf(entry.count)).style(cost ? ChatFormatting.YELLOW : ChatFormatting.GRAY)).addTo(pTooltipComponents);
                    continue;
                }
                if (cost) {
                    CreateLang.translate("table_cloth.total_cost", new Object[0]).style(ChatFormatting.GOLD).addTo(pTooltipComponents);
                }
                for (BigItemStack entry : entries) {
                    CreateLang.builder().add(entry.stack.m_41786_()).text(" x").text(String.valueOf(entry.count)).style(cost ? ChatFormatting.YELLOW : ChatFormatting.GRAY).addTo(pTooltipComponents);
                }
            }
        }
        CreateLang.translate("table_cloth.hand_to_shop_keeper", new Object[0]).style(ChatFormatting.GRAY).addTo(pTooltipComponents);
        CreateLang.translate("table_cloth.sneak_click_discard", new Object[0]).style(ChatFormatting.DARK_GRAY).addTo(pTooltipComponents);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pUsedHand == InteractionHand.OFF_HAND || pPlayer == null || !pPlayer.m_6144_()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)pPlayer.m_21120_(pUsedHand));
        }
        CreateLang.translate("table_cloth.shopping_list_discarded", new Object[0]).sendStatus(pPlayer);
        pPlayer.m_216990_(SoundEvents.f_11713_);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)ItemStack.f_41583_);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        InteractionHand pUsedHand = pContext.m_43724_();
        Player pPlayer = pContext.m_43723_();
        if (pUsedHand == InteractionHand.OFF_HAND || pPlayer == null || !pPlayer.m_6144_()) {
            return InteractionResult.PASS;
        }
        pPlayer.m_21008_(pUsedHand, ItemStack.f_41583_);
        CreateLang.translate("table_cloth.shopping_list_discarded", new Object[0]).sendStatus(pPlayer);
        pPlayer.m_216990_(SoundEvents.f_11713_);
        return InteractionResult.SUCCESS;
    }

    public record ShoppingList(List<IntAttached<BlockPos>> purchases, UUID shopOwner, UUID shopNetwork) {
        public static ShoppingList load(CompoundTag tag) {
            return new ShoppingList(NBTHelper.readCompoundList((ListTag)tag.m_128437_("Purchases", 10), c -> IntAttached.read((CompoundTag)c, NbtUtils::m_129239_)), tag.m_128342_("ShopOwner"), tag.m_128342_("ShopNetwork"));
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("Purchases", (Tag)NBTHelper.writeCompoundList(this.purchases, ia -> ia.serializeNBT(NbtUtils::m_129224_)));
            tag.m_128362_("ShopOwner", this.shopOwner);
            tag.m_128362_("ShopNetwork", this.shopNetwork);
            return tag;
        }

        public void addPurchases(BlockPos clothPos, int amount) {
            for (IntAttached<BlockPos> entry : this.purchases) {
                if (!clothPos.equals(entry.getValue())) continue;
                entry.setFirst((Object)((Integer)entry.getFirst() + amount));
                return;
            }
            this.purchases.add((IntAttached<BlockPos>)IntAttached.with((int)amount, (Object)clothPos));
        }

        public int getPurchases(BlockPos clothPos) {
            for (IntAttached<BlockPos> entry : this.purchases) {
                if (!clothPos.equals(entry.getValue())) continue;
                return (Integer)entry.getFirst();
            }
            return 0;
        }

        public Couple<InventorySummary> bakeEntries(LevelAccessor level, @Nullable BlockPos clothPosToIgnore) {
            InventorySummary input = new InventorySummary();
            InventorySummary output = new InventorySummary();
            for (IntAttached<BlockPos> entry : this.purchases) {
                Object object;
                if (clothPosToIgnore != null && clothPosToIgnore.equals(entry.getValue()) || !((object = level.m_7702_((BlockPos)entry.getValue())) instanceof TableClothBlockEntity)) continue;
                TableClothBlockEntity dcbe = (TableClothBlockEntity)object;
                input.add(dcbe.getPaymentItem(), dcbe.getPaymentAmount() * (Integer)entry.getFirst());
                object = dcbe.requestData.encodedRequest.stacks().iterator();
                while (object.hasNext()) {
                    BigItemStack stackEntry = (BigItemStack)object.next();
                    output.add(stackEntry.stack, stackEntry.count * (Integer)entry.getFirst());
                }
            }
            return Couple.create((Object)output, (Object)input);
        }
    }
}

