/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.dungeon;

import jeresources.config.Settings;
import jeresources.jei.BlankJEIRecipeCategory;
import jeresources.jei.JEIConfig;
import jeresources.jei.dungeon.DungeonWrapper;
import jeresources.reference.Resources;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DungeonCategory
extends BlankJEIRecipeCategory<DungeonWrapper> {
    protected static final int Y_FIRST_ITEM = 44;
    protected static final int X_FIRST_ITEM = 6;
    protected static int SPACING_Y;
    protected static int SPACING_X;
    protected static int ITEMS_PER_PAGE;

    public static void reloadSettings() {
        ITEMS_PER_PAGE = Settings.ITEMS_PER_COLUMN * Settings.ITEMS_PER_ROW * 2;
        SPACING_X = 166 / (Settings.ITEMS_PER_ROW * 2);
        SPACING_Y = 80 / Settings.ITEMS_PER_COLUMN;
    }

    public DungeonCategory() {
        super((IDrawable)JEIConfig.getJeiHelpers().getGuiHelper().createDrawable(Resources.Gui.Jei.TABS, 16, 0, 16, 16));
        DungeonCategory.reloadSettings();
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)"jer.dungeon.title");
    }

    @NotNull
    public IDrawable getBackground() {
        return Resources.Gui.Jei.DUNGEON;
    }

    @NotNull
    public RecipeType<DungeonWrapper> getRecipeType() {
        return JEIConfig.DUNGEON_TYPE;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull DungeonWrapper recipeWrapper, @NotNull IFocusGroup focuses) {
        int x = 6;
        int y = 44;
        int slots = Math.min(recipeWrapper.amountOfItems((IFocus<ItemStack>)((IFocus)focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK).findFirst().orElse(null))), ITEMS_PER_PAGE);
        for (int i = 0; i < slots; ++i) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).addTooltipCallback((IRecipeSlotTooltipCallback)recipeWrapper).addItemStacks(recipeWrapper.getItems((IFocus<ItemStack>)((IFocus)focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK).findFirst().orElse(null)), i, slots));
            if ((x += SPACING_X) < 6 + SPACING_X * Settings.ITEMS_PER_ROW * 2) continue;
            x = 6;
            y += SPACING_Y;
        }
        recipeWrapper.resetLid();
    }
}

