/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import jeresources.compatibility.CompatBase;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;

public class MobTableBuilder {
    private final Map<ResourceLocation, Supplier<LivingEntity>> mobTables = new HashMap<ResourceLocation, Supplier<LivingEntity>>();
    private final Level level = CompatBase.getLevel();

    public void add(ResourceLocation resourceLocation, EntityType<?> entityType) {
        if (MobTableBuilder.isNonLiving(entityType) || !entityType.m_245993_(this.level.m_246046_())) {
            return;
        }
        this.mobTables.put(resourceLocation, () -> (LivingEntity)entityType.m_20615_(this.level));
    }

    public void addSheep(ResourceLocation resourceLocation, EntityType<Sheep> entityType, DyeColor dye) {
        this.mobTables.put(resourceLocation, () -> {
            Sheep sheep = (Sheep)entityType.m_20615_(this.level);
            assert (sheep != null);
            sheep.m_29855_(dye);
            return sheep;
        });
    }

    public Map<ResourceLocation, Supplier<LivingEntity>> getMobTables() {
        return this.mobTables;
    }

    private static boolean isNonLiving(@Nonnull EntityType<?> entityType) {
        return !EntityLootSubProvider.f_244591_.contains(entityType) && entityType.m_20674_() == MobCategory.MISC;
    }
}

