/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.pigment;

import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.providers.IPigmentProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public final class PigmentStack
extends ChemicalStack<Pigment> {
    public static final PigmentStack EMPTY = new PigmentStack(MekanismAPI.EMPTY_PIGMENT, 0L);

    public PigmentStack(IPigmentProvider pigmentProvider, long amount) {
        super((Pigment)pigmentProvider.getChemical(), amount);
    }

    public PigmentStack(PigmentStack stack, long amount) {
        this((IPigmentProvider)stack.getType(), amount);
    }

    @Override
    protected IForgeRegistry<Pigment> getRegistry() {
        return MekanismAPI.pigmentRegistry();
    }

    @Override
    protected Pigment getEmptyChemical() {
        return MekanismAPI.EMPTY_PIGMENT;
    }

    public static PigmentStack readFromNBT(@Nullable CompoundTag nbtTags) {
        if (nbtTags == null || nbtTags.m_128456_()) {
            return EMPTY;
        }
        Pigment type = Pigment.readFromNBT(nbtTags);
        if (type.isEmptyType()) {
            return EMPTY;
        }
        long amount = nbtTags.m_128454_("amount");
        if (amount <= 0L) {
            return EMPTY;
        }
        return new PigmentStack(type, amount);
    }

    public static PigmentStack readFromPacket(FriendlyByteBuf buf) {
        Pigment pigment = (Pigment)buf.readRegistryIdSafe(Pigment.class);
        if (pigment.isEmptyType()) {
            return EMPTY;
        }
        return new PigmentStack(pigment, buf.m_130258_());
    }

    public PigmentStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new PigmentStack(this, this.getAmount());
    }
}

