/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.Collections;
import java.util.List;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiVerticalRateBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.tab.GuiBoilerTab;
import mekanism.client.gui.element.tab.GuiHeatTab;
import mekanism.client.jei.MekanismJEIRecipeType;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.boiler.BoilerMultiblockData;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.tile.multiblock.TileEntityBoilerCasing;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class GuiThermoelectricBoiler
extends GuiMekanismTile<TileEntityBoilerCasing, MekanismTileContainer<TileEntityBoilerCasing>> {
    public GuiThermoelectricBoiler(MekanismTileContainer<TileEntityBoilerCasing> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.dynamicSlots = true;
        this.f_97726_ += 40;
        this.f_97731_ += 2;
        this.f_97729_ = 5;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiInnerScreen((IGuiWrapper)this, 60, 23, 96, 40, () -> {
            BoilerMultiblockData multiblock = (BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock();
            return List.of(MekanismLang.TEMPERATURE.translate(MekanismUtils.getTemperatureDisplay(multiblock.getTotalTemperature(), UnitDisplayUtils.TemperatureUnit.KELVIN, true)), MekanismLang.BOIL_RATE.translate(TextUtils.format(multiblock.lastBoilRate)), MekanismLang.MAX_BOIL_RATE.translate(TextUtils.format(multiblock.lastMaxBoil)));
        }).jeiCategories(new MekanismJEIRecipeType[]{MekanismJEIRecipeType.BOILER}));
        this.addRenderableWidget(new GuiBoilerTab((IGuiWrapper)this, (TileEntityBoilerCasing)this.tile, GuiBoilerTab.BoilerTab.STAT));
        this.addRenderableWidget(new GuiVerticalRateBar(this, new GuiBar.IBarInfoHandler(){

            @Override
            public Component getTooltip() {
                return MekanismLang.BOIL_RATE.translate(TextUtils.format(((BoilerMultiblockData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tile).getMultiblock()).lastBoilRate));
            }

            @Override
            public double getLevel() {
                BoilerMultiblockData multiblock = (BoilerMultiblockData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tile).getMultiblock();
                return Math.min(1.0, (double)multiblock.lastBoilRate / (double)multiblock.lastMaxBoil);
            }
        }, 44, 13));
        this.addRenderableWidget(new GuiVerticalRateBar(this, new GuiBar.IBarInfoHandler(){

            @Override
            public Component getTooltip() {
                return MekanismLang.MAX_BOIL_RATE.translate(TextUtils.format(((BoilerMultiblockData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tile).getMultiblock()).lastMaxBoil));
            }

            @Override
            public double getLevel() {
                BoilerMultiblockData multiblock = (BoilerMultiblockData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tile).getMultiblock();
                return Math.min(1.0, (double)multiblock.lastMaxBoil * HeatUtils.getWaterThermalEnthalpy() / ((double)multiblock.superheatingElements * MekanismConfig.general.superheatingHeatTransfer.get()));
            }
        }, 164, 13));
        this.addRenderableWidget(new GuiGasGauge(() -> ((BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock()).superheatedCoolantTank, () -> ((BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock()).getGasTanks(null), GaugeType.STANDARD, this, 6, 13).setLabel((Component)MekanismLang.BOILER_HEATED_COOLANT_TANK.translateColored(EnumColor.ORANGE, new Object[0])));
        this.addRenderableWidget(new GuiFluidGauge(() -> ((BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock()).waterTank, () -> ((BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock()).getFluidTanks(null), GaugeType.STANDARD, this, 26, 13).setLabel((Component)MekanismLang.BOILER_WATER_TANK.translateColored(EnumColor.INDIGO, new Object[0])));
        this.addRenderableWidget(new GuiGasGauge(() -> ((BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock()).steamTank, () -> ((BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock()).getGasTanks(null), GaugeType.STANDARD, this, 172, 13).setLabel((Component)MekanismLang.BOILER_STEAM_TANK.translateColored(EnumColor.GRAY, new Object[0])));
        this.addRenderableWidget(new GuiGasGauge(() -> ((BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock()).cooledCoolantTank, () -> ((BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock()).getGasTanks(null), GaugeType.STANDARD, this, 192, 13).setLabel((Component)MekanismLang.BOILER_COOLANT_TANK.translateColored(EnumColor.AQUA, new Object[0])));
        this.addRenderableWidget(new GuiHeatTab(this, () -> {
            Component environment = MekanismUtils.getTemperatureDisplay(((BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock()).lastEnvironmentLoss, UnitDisplayUtils.TemperatureUnit.KELVIN, false);
            return Collections.singletonList(MekanismLang.DISSIPATED_RATE.translate(environment));
        }));
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        this.drawString(guiGraphics, this.f_169604_, this.f_97730_, this.f_97731_, this.titleTextColor());
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }
}

