/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.hud;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import mekanism.client.gui.GuiUtils;
import mekanism.client.render.HUDRenderer;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.curios.CuriosIntegration;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.tags.MekanismTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.items.IItemHandler;

public class MekanismHUD
implements IGuiOverlay {
    public static final MekanismHUD INSTANCE = new MekanismHUD();
    private static final EquipmentSlot[] EQUIPMENT_ORDER = new EquipmentSlot[]{EquipmentSlot.OFFHAND, EquipmentSlot.MAINHAND, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private final HUDRenderer hudRenderer = new HUDRenderer();

    private MekanismHUD() {
    }

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTicks, int screenWidth, int screenHeight) {
        Minecraft minecraft = gui.getMinecraft();
        LocalPlayer player = minecraft.f_91074_;
        if (!minecraft.f_91066_.f_92062_ && player != null && !player.m_5833_() && MekanismConfig.client.enableHUD.get()) {
            Optional<? extends IItemHandler> invOptional;
            IItemHUDProvider hudProvider;
            Item item;
            ItemStack stack;
            int count = 0;
            ArrayList<List<Component>> renderStrings = new ArrayList<List<Component>>();
            for (EquipmentSlot slotType : EQUIPMENT_ORDER) {
                stack = player.m_6844_(slotType);
                item = stack.m_41720_();
                if (!(item instanceof IItemHUDProvider)) continue;
                hudProvider = (IItemHUDProvider)item;
                count += this.makeComponent(arg_0 -> MekanismHUD.lambda$render$0(hudProvider, (Player)player, stack, slotType, arg_0), renderStrings);
            }
            if (Mekanism.hooks.CuriosLoaded && (invOptional = CuriosIntegration.getCuriosInventory((LivingEntity)player)).isPresent()) {
                IItemHandler inv = invOptional.get();
                int slots = inv.getSlots();
                for (int i = 0; i < slots; ++i) {
                    stack = inv.getStackInSlot(i);
                    item = stack.m_41720_();
                    if (!(item instanceof IItemHUDProvider)) continue;
                    hudProvider = (IItemHUDProvider)item;
                    count += this.makeComponent(arg_0 -> MekanismHUD.lambda$render$1(hudProvider, (Player)player, stack, arg_0), renderStrings);
                }
            }
            Font font = gui.m_93082_();
            boolean reverseHud = MekanismConfig.client.reverseHUD.get();
            int maxTextHeight = screenHeight;
            if (count > 0) {
                float hudScale = MekanismConfig.client.hudScale.get();
                int xScale = (int)((float)screenWidth / hudScale);
                int yScale = (int)((float)screenHeight / hudScale);
                int start = renderStrings.size() * 2 + count * 9;
                int y = yScale - start;
                maxTextHeight = (int)((float)y * hudScale);
                PoseStack pose = guiGraphics.m_280168_();
                pose.m_85836_();
                pose.m_85841_(hudScale, hudScale, hudScale);
                int backgroundColor = minecraft.f_91066_.m_92170_(0.0f);
                if (backgroundColor != 0) {
                    int maxTextWidth = 0;
                    for (List list : renderStrings) {
                        for (Component text : list) {
                            int textWidth = font.m_92852_((FormattedText)text);
                            if (textWidth <= maxTextWidth) continue;
                            maxTextWidth = textWidth;
                        }
                    }
                    int n = reverseHud ? xScale - maxTextWidth - 2 : 2;
                    GuiUtils.drawBackdrop(guiGraphics, Minecraft.m_91087_(), n, y, maxTextWidth, maxTextHeight, -1);
                }
                for (List list : renderStrings) {
                    for (Component text : list) {
                        int textWidth = font.m_92852_((FormattedText)text);
                        int x = reverseHud ? xScale - textWidth - 2 : 2;
                        guiGraphics.m_280430_(font, text, x, y, -3618616);
                        y += 9;
                    }
                    y += 2;
                }
                pose.m_85849_();
            }
            if (player.m_6844_(EquipmentSlot.HEAD).m_204117_(MekanismTags.Items.MEKASUIT_HUD_RENDERER)) {
                this.hudRenderer.renderHUD(minecraft, guiGraphics, font, partialTicks, screenWidth, screenHeight, maxTextHeight, reverseHud);
            }
        }
    }

    private int makeComponent(Consumer<List<Component>> adder, List<List<Component>> initial) {
        ArrayList list = new ArrayList();
        adder.accept(list);
        int size = list.size();
        if (size > 0) {
            initial.add(list);
        }
        return size;
    }

    private static /* synthetic */ void lambda$render$1(IItemHUDProvider hudProvider, Player player, ItemStack stack, List list) {
        hudProvider.addCurioHUDStrings(list, player, stack);
    }

    private static /* synthetic */ void lambda$render$0(IItemHUDProvider hudProvider, Player player, ItemStack stack, EquipmentSlot slotType, List list) {
        hudProvider.addHUDStrings(list, player, stack, slotType);
    }
}

