/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.sound;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import mekanism.api.Upgrade;
import mekanism.client.sound.FlamethrowerSound;
import mekanism.client.sound.GeigerSound;
import mekanism.client.sound.GravitationalModulationSound;
import mekanism.client.sound.JetpackSound;
import mekanism.client.sound.PlayerSound;
import mekanism.client.sound.ScubaMaskSound;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.registration.impl.SoundEventRegistryObject;
import mekanism.common.tile.interfaces.ITileSound;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.util.WorldUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.event.sound.SoundEngineLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="mekanism", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class SoundHandler {
    private static final Map<UUID, PlayerSound> jetpackSounds = new Object2ObjectOpenHashMap();
    private static final Map<UUID, PlayerSound> scubaMaskSounds = new Object2ObjectOpenHashMap();
    private static final Map<UUID, PlayerSound[]> flamethrowerSounds = new Object2ObjectOpenHashMap();
    private static final Map<UUID, PlayerSound> gravitationalModulationSounds = new Object2ObjectOpenHashMap();
    public static final Map<RadiationManager.RadiationScale, GeigerSound> radiationSoundMap = new EnumMap<RadiationManager.RadiationScale, GeigerSound>(RadiationManager.RadiationScale.class);
    private static final Long2ObjectMap<SoundInstance> soundMap = new Long2ObjectOpenHashMap();
    private static boolean IN_MUFFLED_CHECK = false;
    private static SoundEngine soundEngine;
    private static boolean hadPlayerSounds;

    private SoundHandler() {
    }

    public static void clearPlayerSounds() {
        jetpackSounds.clear();
        scubaMaskSounds.clear();
        flamethrowerSounds.clear();
        gravitationalModulationSounds.clear();
    }

    public static void clearPlayerSounds(UUID uuid) {
        jetpackSounds.remove(uuid);
        scubaMaskSounds.remove(uuid);
        flamethrowerSounds.remove(uuid);
        gravitationalModulationSounds.remove(uuid);
    }

    public static void startSound(@NotNull LevelAccessor world, @NotNull UUID uuid, @NotNull PlayerSound.SoundType soundType) {
        switch (soundType) {
            case JETPACK: {
                SoundHandler.startSound(world, uuid, jetpackSounds, JetpackSound::new);
                break;
            }
            case SCUBA_MASK: {
                SoundHandler.startSound(world, uuid, scubaMaskSounds, ScubaMaskSound::new);
                break;
            }
            case FLAMETHROWER: {
                SoundHandler.startSounds(world, uuid, flamethrowerSounds, FlamethrowerSound.Active::new, FlamethrowerSound.Idle::new);
                break;
            }
            case GRAVITATIONAL_MODULATOR: {
                SoundHandler.startSound(world, uuid, gravitationalModulationSounds, GravitationalModulationSound::new);
            }
        }
    }

    private static void startSound(LevelAccessor world, UUID uuid, Map<UUID, PlayerSound> knownSounds, Function<Player, PlayerSound> soundCreator) {
        if (knownSounds.containsKey(uuid)) {
            if (SoundHandler.playerSoundsEnabled()) {
                SoundHandler.restartSounds(knownSounds.get(uuid));
            }
        } else {
            Player player = world.m_46003_(uuid);
            if (player != null) {
                PlayerSound sound = soundCreator.apply(player);
                SoundHandler.playSound((SoundInstance)sound);
                knownSounds.put(uuid, sound);
            }
        }
    }

    @SafeVarargs
    private static void startSounds(LevelAccessor world, UUID uuid, Map<UUID, PlayerSound[]> knownSounds, Function<Player, PlayerSound> ... soundCreators) {
        if (knownSounds.containsKey(uuid)) {
            if (SoundHandler.playerSoundsEnabled()) {
                SoundHandler.restartSounds(knownSounds.get(uuid));
            }
        } else {
            Player player = world.m_46003_(uuid);
            if (player != null) {
                PlayerSound[] sounds = new PlayerSound[soundCreators.length];
                for (int i = 0; i < soundCreators.length; ++i) {
                    sounds[i] = soundCreators[i].apply(player);
                    SoundHandler.playSound((SoundInstance)sounds[i]);
                }
                knownSounds.put(uuid, sounds);
            }
        }
    }

    public static void restartSounds() {
        boolean hasPlayerSounds = SoundHandler.playerSoundsEnabled();
        if (hasPlayerSounds != hadPlayerSounds) {
            hadPlayerSounds = hasPlayerSounds;
            if (hasPlayerSounds) {
                jetpackSounds.values().forEach(xva$0 -> SoundHandler.restartSounds(xva$0));
                scubaMaskSounds.values().forEach(xva$0 -> SoundHandler.restartSounds(xva$0));
                flamethrowerSounds.values().forEach(SoundHandler::restartSounds);
                gravitationalModulationSounds.values().forEach(xva$0 -> SoundHandler.restartSounds(xva$0));
                radiationSoundMap.values().forEach(xva$0 -> SoundHandler.restartSounds(xva$0));
            }
        }
    }

    private static void restartSounds(PlayerSound ... sounds) {
        for (PlayerSound sound : sounds) {
            if (sound.m_7801_() || soundEngine == null || SoundHandler.soundEngine.f_120226_.containsKey((Object)sound)) continue;
            SoundHandler.playSound((SoundInstance)sound);
        }
    }

    private static boolean playerSoundsEnabled() {
        return SoundHandler.getVolume(SoundSource.MASTER) > 0.0f && SoundHandler.getVolume(SoundSource.PLAYERS) > 0.0f;
    }

    private static float getVolume(SoundSource category) {
        return Minecraft.m_91087_().f_91066_.m_92147_(category);
    }

    public static void playSound(SoundEventRegistryObject<?> soundEventRO) {
        SoundHandler.playSound((SoundEvent)soundEventRO.get());
    }

    public static void playSound(SoundEvent sound) {
        SoundHandler.playSound((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)sound, (float)1.0f, (float)MekanismConfig.client.baseSoundVolume.get()));
    }

    public static void playSound(SoundInstance sound) {
        Minecraft.m_91087_().m_91106_().m_120367_(sound);
    }

    public static SoundInstance startTileSound(SoundEvent soundEvent, SoundSource category, float volume, RandomSource random, BlockPos pos) {
        return SoundHandler.startTileSound(soundEvent, category, volume, random, pos, true);
    }

    public static SoundInstance startTileSound(SoundEvent soundEvent, SoundSource category, float volume, RandomSource random, BlockPos pos, boolean looping) {
        Object s = (SoundInstance)soundMap.get(pos.m_121878_());
        if (s == null || !Minecraft.m_91087_().m_91106_().m_120403_(s)) {
            s = new TileTickableSound(soundEvent, category, random, pos, volume, looping);
            if (!SoundHandler.isClientPlayerInRange(s)) {
                return null;
            }
            SoundHandler.playSound(s);
            s = (SoundInstance)soundMap.get(pos.m_121878_());
        }
        return s;
    }

    public static void stopTileSound(BlockPos pos) {
        long posKey = pos.m_121878_();
        SoundInstance s = (SoundInstance)soundMap.get(posKey);
        if (s != null) {
            Minecraft.m_91087_().m_91106_().m_120399_(s);
            soundMap.remove(posKey);
        }
    }

    private static boolean isClientPlayerInRange(SoundInstance sound) {
        if (sound.m_7796_() || sound.m_7438_() == SoundInstance.Attenuation.NONE) {
            return true;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        Sound s = sound.m_5891_();
        if (s == null) {
            sound.m_6775_(Minecraft.m_91087_().m_91106_());
            s = sound.m_5891_();
        }
        int attenuationDistance = s.m_119798_();
        float scaledDistance = Math.max(sound.m_7769_(), 1.0f) * (float)attenuationDistance;
        return player.m_20182_().m_82531_(sound.m_7772_(), sound.m_7780_(), sound.m_7778_()) < (double)(scaledDistance * scaledDistance);
    }

    @SubscribeEvent
    public static void onSoundEngineSetup(SoundEngineLoadEvent event) {
        if (soundEngine == null) {
            soundEngine = event.getEngine();
        }
    }

    public static void onTilePlaySound(PlaySoundEvent event) {
        SoundInstance resultSound = event.getSound();
        if (resultSound == null || IN_MUFFLED_CHECK) {
            return;
        }
        ResourceLocation soundLoc = event.getOriginalSound().m_7904_();
        if (!soundLoc.m_135827_().startsWith("mekanism")) {
            return;
        }
        SoundInstance soundInstance = event.getOriginalSound();
        if (soundInstance instanceof PlayerSound) {
            PlayerSound sound = (PlayerSound)soundInstance;
            event.setSound((SoundInstance)sound);
            return;
        }
        if (event.getName().startsWith("tile.")) {
            BlockPos pos = BlockPos.m_274561_((double)(resultSound.m_7772_() - 0.5), (double)(resultSound.m_7780_() - 0.5), (double)(resultSound.m_7778_() - 0.5));
            soundMap.put(pos.m_121878_(), (Object)resultSound);
        }
    }

    private static class TileTickableSound
    extends AbstractTickableSoundInstance {
        private final float originalVolume;
        private final int checkInterval = 20 + ThreadLocalRandom.current().nextInt(20);

        TileTickableSound(SoundEvent soundEvent, SoundSource category, RandomSource random, BlockPos pos, float volume, boolean looping) {
            super(soundEvent, category, random);
            this.originalVolume = volume * MekanismConfig.client.baseSoundVolume.get();
            this.f_119575_ = (float)pos.m_123341_() + 0.5f;
            this.f_119576_ = (float)pos.m_123342_() + 0.5f;
            this.f_119577_ = (float)pos.m_123343_() + 0.5f;
            this.f_119573_ = this.originalVolume * this.getTileVolumeFactor();
            this.f_119578_ = looping;
            this.f_119579_ = 0;
        }

        public void m_7788_() {
            if (Minecraft.m_91087_().f_91073_.m_46467_() % (long)this.checkInterval == 0L) {
                if (!SoundHandler.isClientPlayerInRange((SoundInstance)this)) {
                    this.m_119609_();
                    return;
                }
                IN_MUFFLED_CHECK = true;
                this.f_119573_ = this.originalVolume;
                SoundInstance s = ForgeHooksClient.playSound((SoundEngine)soundEngine, (SoundInstance)this);
                IN_MUFFLED_CHECK = false;
                if (s == this) {
                    this.f_119573_ = this.originalVolume * this.getTileVolumeFactor();
                } else if (s == null) {
                    this.m_119609_();
                } else {
                    this.f_119573_ = s.m_7769_() * this.getTileVolumeFactor();
                }
            }
        }

        private float getTileVolumeFactor() {
            IUpgradeTile upgradeTile;
            BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)Minecraft.m_91087_().f_91073_, BlockPos.m_274561_((double)this.m_7772_(), (double)this.m_7780_(), (double)this.m_7778_()));
            float retVolume = 1.0f;
            if (tile instanceof IUpgradeTile && (upgradeTile = (IUpgradeTile)tile).supportsUpgrade(Upgrade.MUFFLING)) {
                int mufflerCount = upgradeTile.getComponent().getUpgrades(Upgrade.MUFFLING);
                retVolume = 1.0f - (float)mufflerCount / (float)Upgrade.MUFFLING.getMax();
            }
            if (tile instanceof ITileSound) {
                ITileSound tileSound = (ITileSound)tile;
                retVolume *= tileSound.getVolume();
            }
            return retVolume;
        }

        public float m_7769_() {
            if (this.f_119570_ == null) {
                this.m_6775_(Minecraft.m_91087_().m_91106_());
            }
            return super.m_7769_();
        }

        public boolean m_7784_() {
            return true;
        }
    }
}

