/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.heat;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.heat.HeatAPI;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.heat.IMekanismHeatHandler;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.util.EnumUtils;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public interface ITileHeatHandler
extends IMekanismHeatHandler {
    default public void updateHeatCapacitors(@Nullable Direction side) {
        for (IHeatCapacitor capacitor : this.getHeatCapacitors(side)) {
            if (!(capacitor instanceof BasicHeatCapacitor)) continue;
            BasicHeatCapacitor heatCapacitor = (BasicHeatCapacitor)capacitor;
            heatCapacitor.update();
        }
    }

    @Nullable
    default public IHeatHandler getAdjacent(Direction side) {
        return null;
    }

    default public HeatAPI.HeatTransfer simulate() {
        return new HeatAPI.HeatTransfer(this.simulateAdjacent(), this.simulateEnvironment());
    }

    default public double getAmbientTemperature(Direction side) {
        return 300.0;
    }

    default public double simulateEnvironment() {
        double environmentTransfer = 0.0;
        for (Direction side : EnumUtils.DIRECTIONS) {
            double heatCapacity = this.getTotalHeatCapacity(side);
            double invConduction = 10000.0 + this.getTotalInverseInsulation(side) + this.getTotalInverseConductionCoefficient(side);
            double tempToTransfer = (this.getTotalTemperature(side) - this.getAmbientTemperature(side)) / invConduction;
            this.handleHeat(-tempToTransfer * heatCapacity, side);
            if (!(tempToTransfer > 0.0)) continue;
            environmentTransfer += tempToTransfer;
        }
        return environmentTransfer;
    }

    default public double simulateAdjacent() {
        double adjacentTransfer = 0.0;
        for (Direction side : EnumUtils.DIRECTIONS) {
            IHeatHandler sink = this.getAdjacent(side);
            if (sink == null) continue;
            double heatCapacity = this.getTotalHeatCapacity(side);
            double invConduction = sink.getTotalInverseConduction() + this.getTotalInverseConductionCoefficient(side);
            double tempToTransfer = (this.getTotalTemperature(side) - this.getAmbientTemperature(side)) / invConduction;
            double heatToTransfer = tempToTransfer * heatCapacity;
            this.handleHeat(-heatToTransfer, side);
            sink.handleHeat(heatToTransfer);
            adjacentTransfer = this.incrementAdjacentTransfer(adjacentTransfer, tempToTransfer, side);
        }
        return adjacentTransfer;
    }

    default public double incrementAdjacentTransfer(double currentAdjacentTransfer, double tempToTransfer, Direction side) {
        return currentAdjacentTransfer + tempToTransfer;
    }
}

