/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config.value;

import java.util.function.IntSupplier;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedValue;
import net.minecraftforge.common.ForgeConfigSpec;

public class CachedIntValue
extends CachedValue<Integer>
implements IntSupplier {
    private boolean resolved;
    private int cachedValue;

    private CachedIntValue(IMekanismConfig config, ForgeConfigSpec.ConfigValue<Integer> internal) {
        super(config, internal);
    }

    public static CachedIntValue wrap(IMekanismConfig config, ForgeConfigSpec.ConfigValue<Integer> internal) {
        return new CachedIntValue(config, internal);
    }

    public int getOrDefault() {
        if (this.resolved || this.isLoaded()) {
            return this.get();
        }
        return (Integer)this.internal.getDefault();
    }

    public int get() {
        if (!this.resolved) {
            this.cachedValue = (Integer)this.internal.get();
            this.resolved = true;
        }
        return this.cachedValue;
    }

    @Override
    public int getAsInt() {
        return this.get();
    }

    public void set(int value) {
        this.internal.set((Object)value);
        this.cachedValue = value;
    }

    @Override
    protected boolean clearCachedValue(boolean checkChanged) {
        if (!this.resolved) {
            return false;
        }
        int oldCachedValue = this.cachedValue;
        this.resolved = false;
        return checkChanged && oldCachedValue != this.get();
    }
}

