/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config.value;

import it.unimi.dsi.fastutil.floats.FloatPredicate;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedMapConfigValue;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;

public class CachedRL2FloatMapConfigValue
extends CachedMapConfigValue<ResourceLocation, Float> {
    private CachedRL2FloatMapConfigValue(IMekanismConfig config, ForgeConfigSpec.ConfigValue<List<? extends String>> internal) {
        super(config, internal);
    }

    public static CachedRL2FloatMapConfigValue define(IMekanismConfig config, ForgeConfigSpec.Builder builder, String path, Supplier<Map<ResourceLocation, Float>> defaults) {
        return CachedRL2FloatMapConfigValue.define(config, builder, path, defaults, f -> true);
    }

    public static CachedRL2FloatMapConfigValue define(IMekanismConfig config, ForgeConfigSpec.Builder builder, String path, Supplier<Map<ResourceLocation, Float>> defaults, FloatPredicate range) {
        return new CachedRL2FloatMapConfigValue(config, (ForgeConfigSpec.ConfigValue<List<? extends String>>)builder.defineListAllowEmpty(path, () -> CachedRL2FloatMapConfigValue.encodeStatic((Map)defaults.get(), CachedRL2FloatMapConfigValue::encodeStatic), o -> {
            String string;
            String[] parts;
            if (o instanceof String && (parts = (string = (String)o).split(",", 2)).length == 2 && ResourceLocation.m_135830_((String)parts[0].toLowerCase(Locale.ROOT))) {
                try {
                    float f = Float.parseFloat(parts[1]);
                    return range.test(f);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        }));
    }

    @Override
    protected void resolve(String encoded, Map<ResourceLocation, Float> resolved) {
        ResourceLocation rl;
        String[] parts = encoded.split(",", 2);
        if (parts.length == 2 && (rl = ResourceLocation.m_135820_((String)parts[0].toLowerCase(Locale.ROOT))) != null) {
            try {
                float value = Float.parseFloat(parts[1]);
                resolved.putIfAbsent(rl, Float.valueOf(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void encode(ResourceLocation key, Float value, Consumer<String> adder) {
        CachedRL2FloatMapConfigValue.encodeStatic(key, value, adder);
    }

    private static void encodeStatic(ResourceLocation key, Float value, Consumer<String> adder) {
        if (value != null) {
            adder.accept(String.valueOf(key) + "," + value);
        }
    }
}

