/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekatool;

import java.util.List;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.math.FloatingLong;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.gear.ItemMekaTool;
import mekanism.common.registries.MekanismModules;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNotNullByDefault
public class ModuleShearingUnit
implements ICustomModule<ModuleShearingUnit> {
    private static final Predicate<Entity> SHEARABLE = entity -> !entity.m_5833_() && entity instanceof IForgeShearable;

    @Override
    public boolean canPerformAction(IModule<ModuleShearingUnit> module, ToolAction action) {
        if (action == ToolActions.SHEARS_DISARM) {
            ItemStack container = module.getContainer();
            Item item = container.m_41720_();
            if (item instanceof ItemMekaTool) {
                ItemMekaTool mekaTool = (ItemMekaTool)item;
                FloatingLong cost = mekaTool.getDestroyEnergy(container, 0.0f, mekaTool.isModuleEnabled(container, MekanismModules.SILK_TOUCH_UNIT));
                return module.hasEnoughEnergy(cost);
            }
            return true;
        }
        if (action == ToolActions.SHEARS_DIG) {
            ItemMekaTool mekaTool;
            ItemStack container = module.getContainer();
            Item item = container.m_41720_();
            return !(item instanceof ItemMekaTool) || (mekaTool = (ItemMekaTool)item).hasEnergyForDigAction(container);
        }
        return ToolActions.DEFAULT_SHEARS_ACTIONS.contains(action);
    }

    @Override
    @NotNull
    public InteractionResult onInteract(IModule<ModuleShearingUnit> module, Player player, LivingEntity entity, InteractionHand hand) {
        if (entity instanceof IForgeShearable) {
            FloatingLong cost = (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageShearEntity.get();
            IEnergyContainer energyContainer = module.getEnergyContainer();
            if (cost.isZero() || energyContainer != null && energyContainer.getEnergy().greaterOrEqual(cost) && this.shearEntity(energyContainer, entity, player, module.getContainer(), entity.m_9236_(), entity.m_20183_())) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    @NotNull
    public ICustomModule.ModuleDispenseResult onDispense(IModule<ModuleShearingUnit> module, BlockSource source) {
        ServerLevel world = source.m_7727_();
        Direction facing = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
        BlockPos pos = source.m_7961_().m_121945_(facing);
        if (this.tryShearBlock(world, pos, facing.m_122424_()) || this.tryShearLivingEntity(module.getEnergyContainer(), world, pos, module.getContainer())) {
            return ICustomModule.ModuleDispenseResult.HANDLED;
        }
        return ICustomModule.ModuleDispenseResult.FAIL_PREVENT_DROP;
    }

    private boolean tryShearBlock(ServerLevel world, BlockPos pos, Direction sideClicked) {
        Block block;
        BlockState state = world.m_8055_(pos);
        if (state.m_204336_(BlockTags.f_13072_) && (block = state.m_60734_()) instanceof BeehiveBlock) {
            BeehiveBlock beehive = (BeehiveBlock)block;
            if ((Integer)state.m_61143_((Property)BeehiveBlock.f_49564_) >= 5) {
                world.m_5594_(null, pos, SoundEvents.f_11697_, SoundSource.BLOCKS, 1.0f, 1.0f);
                BeehiveBlock.m_49600_((Level)world, (BlockPos)pos);
                beehive.m_49594_((Level)world, state, pos, null, BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED);
                return true;
            }
        }
        if (state.m_60713_(Blocks.f_50133_)) {
            Direction side = sideClicked.m_122434_() == Direction.Axis.Y ? Direction.NORTH : sideClicked;
            world.m_5594_(null, pos, SoundEvents.f_12296_, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_7731_(pos, (BlockState)Blocks.f_50143_.m_49966_().m_61124_((Property)CarvedPumpkinBlock.f_51367_, (Comparable)side), 11);
            Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_42577_, 4));
            return true;
        }
        return false;
    }

    private boolean tryShearLivingEntity(@Nullable IEnergyContainer energyContainer, ServerLevel world, BlockPos pos, ItemStack stack) {
        FloatingLong cost = (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageShearEntity.get();
        if (cost.isZero() || energyContainer != null && energyContainer.getEnergy().greaterOrEqual((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageShearEntity.get())) {
            for (LivingEntity entity : world.m_6443_(LivingEntity.class, new AABB(pos), SHEARABLE)) {
                if (!this.shearEntity(energyContainer, entity, null, stack, (Level)world, pos)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean shearEntity(@Nullable IEnergyContainer energyContainer, LivingEntity entity, @Nullable Player player, ItemStack stack, Level world, BlockPos pos) {
        IForgeShearable target = (IForgeShearable)entity;
        if (target.isShearable(stack, world, pos)) {
            if (!world.f_46443_) {
                List drops = target.onSheared(player, stack, world, pos, stack.getEnchantmentLevel(Enchantments.f_44987_));
                for (ItemStack drop : drops) {
                    ItemEntity ent = entity.m_5552_(drop, 1.0f);
                    if (ent == null) continue;
                    ent.m_20256_(ent.m_20184_().m_82520_((double)((world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.1f), (double)(world.f_46441_.m_188501_() * 0.05f), (double)((world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.1f)));
                }
                if (energyContainer != null) {
                    energyContainer.extract((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageShearEntity.get(), Action.EXECUTE, AutomationType.MANUAL);
                }
            }
            return true;
        }
        return false;
    }
}

