/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.qio;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.UUID;
import mekanism.common.content.qio.QIODriveData;
import mekanism.common.content.qio.QIOGlobalItemLookup;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.world.item.ItemStack;

public interface IQIODriveItem {
    default public boolean hasStoredItemMap(ItemStack stack) {
        return ItemDataUtils.hasData(stack, "qioItemMap", 12);
    }

    default public void loadItemMap(ItemStack stack, QIODriveData data) {
        if (this.hasStoredItemMap(stack)) {
            Object2LongMap<HashedItem> itemMap = data.getItemMap();
            long[] array = ItemDataUtils.getLongArray(stack, "qioItemMap");
            if (array.length % 3 == 0) {
                for (int i = 0; i < array.length; ++i) {
                    UUID uuid;
                    HashedItem type;
                    if ((type = QIOGlobalItemLookup.INSTANCE.getTypeByUUID(uuid = new UUID(array[i++], array[i++]))) == null) continue;
                    itemMap.put((Object)type, array[i]);
                }
            }
        }
    }

    default public void writeItemMap(ItemStack stack, QIODriveData map) {
        int i = 0;
        Object2LongMap<HashedItem> itemMap = map.getItemMap();
        long[] serializedMap = new long[3 * itemMap.size()];
        for (Object2LongMap.Entry entry : itemMap.object2LongEntrySet()) {
            UUID uuid = QIOGlobalItemLookup.INSTANCE.getOrTrackUUID((HashedItem)entry.getKey());
            serializedMap[i++] = uuid.getMostSignificantBits();
            serializedMap[i++] = uuid.getLeastSignificantBits();
            serializedMap[i++] = entry.getLongValue();
        }
        ItemDataUtils.setLongArrayOrRemove(stack, "qioItemMap", serializedMap);
    }

    public long getCountCapacity(ItemStack var1);

    public int getTypeCapacity(ItemStack var1);

    public record DriveMetadata(long count, int types) {
        public void write(ItemStack stack) {
            ItemDataUtils.setLongOrRemove(stack, "qioMetaCount", this.count);
            ItemDataUtils.setIntOrRemove(stack, "qioMetaTypes", this.types);
        }

        public static DriveMetadata load(ItemStack stack) {
            return new DriveMetadata(ItemDataUtils.getLong(stack, "qioMetaCount"), ItemDataUtils.getInt(stack, "qioMetaTypes"));
        }
    }
}

