/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer;

import it.unimi.dsi.fastutil.objects.ObjectIntImmutablePair;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.common.integration.computer.BaseComputerHelper;
import mekanism.common.integration.computer.BoundMethodHolder;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.MethodData;
import mekanism.common.integration.computer.MethodHelpData;
import org.jetbrains.annotations.Nullable;

@ParametersAreNotNullByDefault
public class ComputerMethodFactory<T> {
    protected static String[] NO_STRINGS = new String[0];
    protected static Class<?>[] NO_CLASSES = new Class[0];
    private static final Comparator<MethodData<?>> METHODDATA_COMPARATOR = Comparator.comparing(MethodData::name).thenComparing(md -> md.argumentNames().length);
    protected static MethodHandles.Lookup lookup = MethodHandles.lookup();
    private final List<MethodData<T>> methods = new ArrayList<MethodData<T>>();
    private final Set<ObjectIntPair<String>> methodsKnown = new HashSet<ObjectIntPair<String>>();

    protected static MethodHandle getMethodHandle(Class<?> containingClass, String methodName, Class<?> ... params) {
        try {
            Method method = containingClass.getDeclaredMethod(methodName, params);
            method.setAccessible(true);
            return lookup.unreflect(method);
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException("Couldn't get method handle for " + methodName, roe);
        }
    }

    protected static MethodHandle getGetterHandle(Class<?> containingClass, String fieldName) {
        try {
            Field field = containingClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return lookup.unreflectGetter(field);
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException("Couldn't get getter MethodHandle for " + fieldName, roe);
        }
    }

    protected void register(MethodData.Builder<T> methodData) {
        this.register(methodData.build());
    }

    protected void register(MethodData<T> methodData) {
        if (!this.methodsKnown.add((ObjectIntPair<String>)new ObjectIntImmutablePair((Object)methodData.name(), methodData.argumentNames().length))) {
            throw new RuntimeException("Duplicate method name " + methodData.name() + "_" + methodData.argumentNames().length);
        }
        this.methods.add(methodData);
    }

    void bindTo(@Nullable T subject, BoundMethodHolder holder) {
        WeakReference<T> weakSubject = subject != null ? new WeakReference<T>(subject) : null;
        for (MethodData<T> methodData : this.methods) {
            if (!methodData.supports(subject)) continue;
            holder.register(methodData, weakSubject, false);
        }
    }

    public List<MethodHelpData> getHelpData() {
        return this.methods.stream().sorted(METHODDATA_COMPARATOR).map(MethodHelpData::from).collect(Collectors.toList());
    }

    @FunctionalInterface
    public static interface ComputerFunctionCaller<T> {
        public Object apply(@Nullable T var1, BaseComputerHelper var2) throws ComputerException;
    }
}

