/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.bracket;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotation.BracketValidator;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import java.util.Optional;
import java.util.function.Predicate;
import mekanism.api.MekanismAPI;
import mekanism.common.integration.crafttweaker.CrTConstants;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.api.BracketValidators")
public class CrTBracketValidators {
    @ZenCodeType.Method
    @BracketValidator(value="gas")
    public static boolean validateGasStack(String tokens) {
        return CrTBracketValidators.validate("gas", tokens, MekanismAPI.gasRegistry());
    }

    @ZenCodeType.Method
    @BracketValidator(value="infuse_type")
    public static boolean validateInfusionStack(String tokens) {
        return CrTBracketValidators.validate("infuse_type", tokens, MekanismAPI.infuseTypeRegistry());
    }

    @ZenCodeType.Method
    @BracketValidator(value="pigment")
    public static boolean validatePigmentStack(String tokens) {
        return CrTBracketValidators.validate("pigment", tokens, MekanismAPI.pigmentRegistry());
    }

    @ZenCodeType.Method
    @BracketValidator(value="slurry")
    public static boolean validateSlurryStack(String tokens) {
        return CrTBracketValidators.validate("slurry", tokens, MekanismAPI.slurryRegistry());
    }

    @ZenCodeType.Method
    @BracketValidator(value="robit_skin")
    public static boolean validateRobitSkin(String tokens) {
        return CrTBracketValidators.validate("robit_skin", tokens, MekanismAPI.ROBIT_SKIN_REGISTRY_NAME);
    }

    @ZenCodeType.Method
    @BracketValidator(value="module_data")
    public static boolean validateModuleData(String tokens) {
        return CrTBracketValidators.validate("module_data", tokens, MekanismAPI.moduleRegistry());
    }

    private static boolean validate(String bracket, String tokens, IForgeRegistry<?> registry) {
        return CrTBracketValidators.validate(bracket, tokens, (ResourceLocation registryName) -> CrTBracketValidators.isRegistryUnlocked(registry) || registry.containsKey(registryName));
    }

    private static boolean isRegistryUnlocked(IForgeRegistry<?> registry) {
        ForgeRegistry forgeRegistry;
        return registry instanceof ForgeRegistry && !(forgeRegistry = (ForgeRegistry)registry).isLocked();
    }

    private static boolean validate(String bracket, String tokens, ResourceKey<? extends Registry<?>> registryKey) {
        return CrTBracketValidators.validate(bracket, tokens, (ResourceLocation registryName) -> {
            Optional registry = CraftTweakerAPI.getAccessibleElementsProvider().registryAccess().m_6632_(registryKey);
            return registry.isEmpty() || ((Registry)registry.get()).m_7804_(registryName);
        });
    }

    private static boolean validate(String bracket, String tokens, Predicate<ResourceLocation> unlockedOrHas) {
        ResourceLocation registryName = ResourceLocation.m_135820_((String)tokens);
        if (registryName == null) {
            CrTConstants.CRT_LOGGER.error("Could not get BEP <{}:{}>. Syntax is <{}:modid:{}_name>", (Object)bracket, (Object)tokens, (Object)bracket, (Object)bracket);
            return false;
        }
        if (unlockedOrHas.test(registryName)) {
            return true;
        }
        String typeName = bracket.replace("_", " ");
        CrTConstants.CRT_LOGGER.error("Could not get {} for <{}:{}>, {} does not appear to exist!", (Object)typeName, (Object)bracket, (Object)tokens, (Object)typeName);
        return false;
    }
}

