/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte;

import com.google.gson.JsonParseException;
import mekanism.common.integration.projecte.NSSGas;
import mekanism.common.integration.projecte.NSSInfuseType;
import mekanism.common.integration.projecte.NSSPigment;
import mekanism.common.integration.projecte.NSSSlurry;
import moze_intel.projecte.api.imc.NSSCreatorInfo;
import moze_intel.projecte.api.nss.NSSCreator;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.InterModComms;

public class NSSHelper {
    private static final NSSCreator gasCreator = gasName -> {
        if (gasName.startsWith("#")) {
            return NSSGas.createTag(NSSHelper.getResourceLocation(gasName.substring(1), "gas tag"));
        }
        return NSSGas.createGas(NSSHelper.getResourceLocation(gasName, "gas"));
    };
    private static final NSSCreator infuseTypeCreator = infuseTypeName -> {
        if (infuseTypeName.startsWith("#")) {
            return NSSInfuseType.createTag(NSSHelper.getResourceLocation(infuseTypeName.substring(1), "infuse type tag"));
        }
        return NSSInfuseType.createInfuseType(NSSHelper.getResourceLocation(infuseTypeName, "infuse type"));
    };
    private static final NSSCreator pigmentCreator = pigmentName -> {
        if (pigmentName.startsWith("#")) {
            return NSSPigment.createTag(NSSHelper.getResourceLocation(pigmentName.substring(1), "pigment tag"));
        }
        return NSSPigment.createPigment(NSSHelper.getResourceLocation(pigmentName, "pigment"));
    };
    private static final NSSCreator slurryCreator = slurryName -> {
        if (slurryName.startsWith("#")) {
            return NSSSlurry.createTag(NSSHelper.getResourceLocation(slurryName.substring(1), "slurry tag"));
        }
        return NSSSlurry.createSlurry(NSSHelper.getResourceLocation(slurryName, "slurry"));
    };

    public static void init() {
        NSSHelper.register("GAS", gasCreator);
        NSSHelper.register("INFUSE_TYPE", infuseTypeCreator);
        NSSHelper.register("PIGMENT", pigmentCreator);
        NSSHelper.register("SLURRY", slurryCreator);
    }

    private static void register(String key, NSSCreator creator) {
        InterModComms.sendTo((String)"projecte", (String)"register_nss_serializer", () -> new NSSCreatorInfo(key, creator));
    }

    private static ResourceLocation getResourceLocation(String s, String type) throws JsonParseException {
        try {
            return new ResourceLocation(s);
        }
        catch (ResourceLocationException e) {
            throw new JsonParseException("Malformed " + type + " ID", (Throwable)e);
        }
    }
}

