/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.multiblock;

import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import mekanism.common.lib.math.voxel.VoxelCuboid;
import mekanism.common.lib.math.voxel.VoxelPlane;
import mekanism.common.lib.multiblock.Structure;

public class StructureHelper {
    private StructureHelper() {
    }

    public static VoxelCuboid fetchCuboid(Structure structure, VoxelCuboid minBounds, VoxelCuboid maxBounds) {
        VoxelCuboid prev = null;
        for (Structure.Axis axis : Structure.Axis.AXES) {
            NavigableMap<Integer, VoxelPlane> majorAxisMap = structure.getMajorAxisMap(axis);
            Map.Entry<Integer, VoxelPlane> firstMajor = majorAxisMap.firstEntry();
            Map.Entry<Integer, VoxelPlane> lastMajor = majorAxisMap.lastEntry();
            if (firstMajor == null || !firstMajor.getValue().equals(lastMajor.getValue()) || !firstMajor.getValue().isFull()) {
                return null;
            }
            VoxelCuboid cuboid = VoxelCuboid.from(firstMajor.getValue(), lastMajor.getValue(), firstMajor.getKey(), lastMajor.getKey());
            if (!(prev != null || cuboid.greaterOrEqual(minBounds) && maxBounds.greaterOrEqual(cuboid))) {
                return null;
            }
            if (prev != null && !prev.equals(cuboid)) {
                return null;
            }
            NavigableMap<Integer, VoxelPlane> minorAxisMap = structure.getMinorAxisMap(axis);
            if (!minorAxisMap.isEmpty() && (StructureHelper.hasOutOfBoundsNegativeMinor(minorAxisMap, firstMajor.getKey()) || StructureHelper.hasOutOfBoundsPositiveMinor(minorAxisMap, lastMajor.getKey()))) {
                return null;
            }
            prev = cuboid;
        }
        return prev;
    }

    public static VoxelCuboid fetchCuboid(Structure structure, VoxelCuboid minBounds, VoxelCuboid maxBounds, Set<VoxelCuboid.CuboidSide> sides, int tolerance) {
        if (sides.size() < 2) {
            return null;
        }
        int missing = 0;
        VoxelCuboid.CuboidBuilder builder = new VoxelCuboid.CuboidBuilder();
        for (VoxelCuboid.CuboidSide side : sides) {
            Map.Entry<Integer, VoxelPlane> majorEntry;
            Structure.Axis axis = side.getAxis();
            Structure.Axis horizontal = axis.horizontal();
            Structure.Axis vertical = axis.vertical();
            NavigableMap<Integer, VoxelPlane> majorAxisMap = structure.getMajorAxisMap(axis);
            Map.Entry<Integer, VoxelPlane> entry = majorEntry = side.getFace().isPositive() ? majorAxisMap.lastEntry() : majorAxisMap.firstEntry();
            if (majorEntry == null) {
                return null;
            }
            VoxelPlane plane = majorEntry.getValue();
            if ((missing += plane.getMissing()) > tolerance) {
                return null;
            }
            int majorKey = majorEntry.getKey();
            builder.set(side, majorKey);
            if (!(builder.trySet(VoxelCuboid.CuboidSide.get(VoxelCuboid.CuboidSide.Face.NEGATIVE, horizontal), plane.getMinCol()) && builder.trySet(VoxelCuboid.CuboidSide.get(VoxelCuboid.CuboidSide.Face.POSITIVE, horizontal), plane.getMaxCol()) && builder.trySet(VoxelCuboid.CuboidSide.get(VoxelCuboid.CuboidSide.Face.NEGATIVE, vertical), plane.getMinRow()) && builder.trySet(VoxelCuboid.CuboidSide.get(VoxelCuboid.CuboidSide.Face.POSITIVE, vertical), plane.getMaxRow()))) {
                return null;
            }
            NavigableMap<Integer, VoxelPlane> minorAxisMap = structure.getMinorAxisMap(axis);
            if (minorAxisMap.isEmpty() || !(side.getFace().isPositive() ? StructureHelper.hasOutOfBoundsPositiveMinor(minorAxisMap, majorKey) : StructureHelper.hasOutOfBoundsNegativeMinor(minorAxisMap, majorKey))) continue;
            return null;
        }
        VoxelCuboid ret = builder.build();
        if (!ret.greaterOrEqual(minBounds) || !maxBounds.greaterOrEqual(ret)) {
            return null;
        }
        return ret;
    }

    private static boolean hasOutOfBoundsPositiveMinor(NavigableMap<Integer, VoxelPlane> minorAxisMap, int majorKey) {
        int minorKey;
        Map.Entry<Integer, VoxelPlane> minorEntry = minorAxisMap.lastEntry();
        while (minorEntry != null && (minorKey = minorEntry.getKey().intValue()) > majorKey) {
            if (minorEntry.getValue().hasFrame()) {
                return true;
            }
            minorEntry = minorAxisMap.lowerEntry(minorKey);
        }
        return false;
    }

    private static boolean hasOutOfBoundsNegativeMinor(NavigableMap<Integer, VoxelPlane> minorAxisMap, int majorKey) {
        int minorKey;
        Map.Entry<Integer, VoxelPlane> minorEntry = minorAxisMap.firstEntry();
        while (minorEntry != null && (minorKey = minorEntry.getKey().intValue()) < majorKey) {
            if (minorEntry.getValue().hasFrame()) {
                return true;
            }
            minorEntry = minorAxisMap.higherEntry(minorKey);
        }
        return false;
    }
}

