/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.TileEntitySecurityDesk;
import mekanism.common.util.WorldUtils;
import mekanism.common.util.text.InputValidator;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.network.NetworkEvent;

public class PacketAddTrusted
implements IMekanismPacket {
    public static final int MAX_NAME_LENGTH = 16;
    private final BlockPos tilePosition;
    private final String name;

    public PacketAddTrusted(BlockPos tilePosition, String name) {
        this.tilePosition = tilePosition;
        this.name = name;
    }

    public static boolean validateNameLength(int length) {
        return length >= 3 && length <= 16;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        TileEntitySecurityDesk tile;
        ServerPlayer player;
        if (!this.name.isEmpty() && InputValidator.test(this.name, InputValidator.USERNAME) && (player = context.getSender()) != null && (tile = WorldUtils.getTileEntity(TileEntitySecurityDesk.class, (BlockGetter)player.m_9236_(), this.tilePosition)) != null) {
            tile.addTrusted(this.name);
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.tilePosition);
        buffer.m_130072_(this.name, 16);
    }

    public static PacketAddTrusted decode(FriendlyByteBuf buffer) {
        return new PacketAddTrusted(buffer.m_130135_(), buffer.m_130136_(16));
    }
}

