/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import java.util.UUID;
import mekanism.common.Mekanism;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.to_client.PacketPlayerData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class PacketGearStateUpdate
implements IMekanismPacket {
    private final GearType gearType;
    private final boolean state;
    private final UUID uuid;

    public PacketGearStateUpdate(GearType gearType, UUID uuid, boolean state) {
        this.gearType = gearType;
        this.uuid = uuid;
        this.state = state;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        if (this.gearType == GearType.FLAMETHROWER) {
            Mekanism.playerState.setFlamethrowerState(this.uuid, this.state, false);
        } else if (this.gearType == GearType.JETPACK) {
            Mekanism.playerState.setJetpackState(this.uuid, this.state, false);
        } else if (this.gearType == GearType.SCUBA_MASK) {
            Mekanism.playerState.setScubaMaskState(this.uuid, this.state, false);
        } else if (this.gearType == GearType.GRAVITATIONAL_MODULATOR) {
            Mekanism.playerState.setGravitationalModulationState(this.uuid, this.state, false);
        }
        ServerPlayer player = context.getSender();
        if (player != null) {
            Mekanism.packetHandler().sendToAllTracking(new PacketPlayerData(this.uuid), (Entity)player);
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.gearType);
        buffer.m_130077_(this.uuid);
        buffer.writeBoolean(this.state);
    }

    public static PacketGearStateUpdate decode(FriendlyByteBuf buffer) {
        return new PacketGearStateUpdate((GearType)buffer.m_130066_(GearType.class), buffer.m_130259_(), buffer.readBoolean());
    }

    public static enum GearType {
        FLAMETHROWER,
        JETPACK,
        SCUBA_MASK,
        GRAVITATIONAL_MODULATOR;

    }
}

