/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import org.jetbrains.annotations.Nullable;

public class LambdaMetaFactoryUtil {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

    public static <O, V> Function<O, V> createGetter(Field field, Class<?> objType, String getterName) throws Throwable {
        if (getterName.isEmpty()) {
            MethodHandle getter = LOOKUP.unreflectGetter(field);
            MethodType type = getter.type();
            if (field.getType().isPrimitive()) {
                type = type.wrap().dropParameterTypes(0, 0);
            }
            CallSite site = LambdaMetafactory.metafactory(LOOKUP, "apply", MethodType.methodType(Function.class, MethodHandle.class), type.erase(), MethodHandles.exactInvoker(getter.type()), type);
            return site.getTarget().invokeExact(getter);
        }
        CallSite site = LambdaMetafactory.metafactory(LOOKUP, "apply", MethodType.methodType(Function.class), MethodType.methodType(Object.class, Object.class), LOOKUP.findVirtual(objType, getterName, MethodType.methodType(field.getType())), MethodType.methodType(field.getType(), objType));
        return site.getTarget().invokeExact();
    }

    public static <O, V> BiConsumer<O, V> createSetter(Field field, Class<?> objType, String setterName) throws Throwable {
        Class setterInterface;
        Class<?> fieldType = field.getType();
        if (setterName.isEmpty()) {
            MethodHandle setterMH = LOOKUP.unreflectSetter(field);
            MethodType type = setterMH.type();
            if (fieldType.isPrimitive()) {
                type = type.wrap().changeReturnType(Void.TYPE);
            }
            CallSite site = LambdaMetafactory.metafactory(LOOKUP, "accept", MethodType.methodType(BiConsumer.class, MethodHandle.class), type.erase(), MethodHandles.exactInvoker(setterMH.type()), type);
            return site.getTarget().invokeExact(setterMH);
        }
        Class<Object> setterFieldType = fieldType;
        if (fieldType == Boolean.TYPE) {
            setterInterface = BooleanSetter.class;
        } else if (fieldType == Byte.TYPE) {
            setterInterface = ByteSetter.class;
        } else if (fieldType == Character.TYPE) {
            setterInterface = CharSetter.class;
        } else if (fieldType == Double.TYPE) {
            setterInterface = ObjDoubleConsumer.class;
        } else if (fieldType == Float.TYPE) {
            setterInterface = FloatSetter.class;
        } else if (fieldType == Integer.TYPE) {
            setterInterface = ObjIntConsumer.class;
        } else if (fieldType == Long.TYPE) {
            setterInterface = ObjLongConsumer.class;
        } else if (fieldType == Short.TYPE) {
            setterInterface = ShortSetter.class;
        } else {
            setterInterface = BiConsumer.class;
            setterFieldType = Object.class;
        }
        CallSite site = LambdaMetafactory.metafactory(LOOKUP, "accept", MethodType.methodType(setterInterface), MethodType.methodType(Void.TYPE, Object.class, setterFieldType), LOOKUP.findVirtual(objType, setterName, MethodType.methodType(Void.TYPE, fieldType)), MethodType.methodType(Void.TYPE, objType, fieldType));
        CallSiteInfo siteInfo = new CallSiteInfo(site, null);
        if (fieldType == Boolean.TYPE) {
            BooleanSetter setter = siteInfo.handle == null ? siteInfo.site.getTarget().invokeExact() : siteInfo.site.getTarget().invokeExact(siteInfo.handle);
            return (instance, value) -> setter.accept(instance, (Boolean)value);
        }
        if (fieldType == Byte.TYPE) {
            ByteSetter setter = siteInfo.handle == null ? siteInfo.site.getTarget().invokeExact() : siteInfo.site.getTarget().invokeExact(siteInfo.handle);
            return (instance, value) -> setter.accept(instance, (Byte)value);
        }
        if (fieldType == Character.TYPE) {
            CharSetter setter = siteInfo.handle == null ? siteInfo.site.getTarget().invokeExact() : siteInfo.site.getTarget().invokeExact(siteInfo.handle);
            return (instance, value) -> setter.accept(instance, ((Character)value).charValue());
        }
        if (fieldType == Double.TYPE) {
            ObjDoubleConsumer setter = siteInfo.handle == null ? siteInfo.site.getTarget().invokeExact() : siteInfo.site.getTarget().invokeExact(siteInfo.handle);
            return (instance, value) -> setter.accept(instance, (Double)value);
        }
        if (fieldType == Float.TYPE) {
            FloatSetter setter = siteInfo.handle == null ? siteInfo.site.getTarget().invokeExact() : siteInfo.site.getTarget().invokeExact(siteInfo.handle);
            return (instance, value) -> setter.accept(instance, ((Float)value).floatValue());
        }
        if (fieldType == Integer.TYPE) {
            ObjIntConsumer setter = siteInfo.handle == null ? siteInfo.site.getTarget().invokeExact() : siteInfo.site.getTarget().invokeExact(siteInfo.handle);
            return (instance, value) -> setter.accept(instance, (Integer)value);
        }
        if (fieldType == Long.TYPE) {
            ObjLongConsumer setter = siteInfo.handle == null ? siteInfo.site.getTarget().invokeExact() : siteInfo.site.getTarget().invokeExact(siteInfo.handle);
            return (instance, value) -> setter.accept(instance, (Long)value);
        }
        if (fieldType == Short.TYPE) {
            ShortSetter setter = siteInfo.handle == null ? siteInfo.site.getTarget().invokeExact() : siteInfo.site.getTarget().invokeExact(siteInfo.handle);
            return (instance, value) -> setter.accept(instance, (Short)value);
        }
        return siteInfo.handle == null ? siteInfo.site.getTarget().invokeExact() : siteInfo.site.getTarget().invokeExact(siteInfo.handle);
    }

    @FunctionalInterface
    private static interface BooleanSetter<O> {
        public void accept(O var1, boolean var2);
    }

    @FunctionalInterface
    private static interface ByteSetter<O> {
        public void accept(O var1, byte var2);
    }

    @FunctionalInterface
    private static interface CharSetter<O> {
        public void accept(O var1, char var2);
    }

    @FunctionalInterface
    private static interface FloatSetter<O> {
        public void accept(O var1, float var2);
    }

    @FunctionalInterface
    private static interface ShortSetter<O> {
        public void accept(O var1, short var2);
    }

    private record CallSiteInfo(CallSite site, @Nullable MethodHandle handle) {
    }
}

