/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.container.v1;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public final class QuickMoveRuleSet {
    private static final Predicate<Slot> IS_INVENTORY = slot -> slot.f_40218_ instanceof Inventory;
    private static final Predicate<Slot> IS_INVENTORY_ITEMS = slot -> IS_INVENTORY.test((Slot)slot) && slot.m_150661_() < 36;
    private static final Predicate<Slot> IS_INVENTORY_ARMOR = slot -> IS_INVENTORY.test((Slot)slot) && slot.m_150661_() >= 36 && slot.m_150661_() < 40;
    private static final Predicate<Slot> IS_HOTBAR = slot -> IS_INVENTORY_ITEMS.test((Slot)slot) && Inventory.m_36045_((int)slot.m_150661_());
    private static final Predicate<Slot> IS_NOT_HOTBAR = slot -> IS_INVENTORY_ITEMS.test((Slot)slot) && !IS_HOTBAR.test((Slot)slot);
    private final List<Rule> rules = new ArrayList<Rule>();
    private final List<Slot> slots;
    private final Action action;
    private final Type type;

    private QuickMoveRuleSet(AbstractContainerMenu menu, Action action, Type type) {
        this.slots = menu.f_38839_;
        this.action = action;
        this.type = type;
    }

    public static QuickMoveRuleSet of(AbstractContainerMenu menu, Action action) {
        return QuickMoveRuleSet.of(menu, action, Type.RELAXED);
    }

    public static QuickMoveRuleSet of(AbstractContainerMenu menu, Action action, Type type) {
        return new QuickMoveRuleSet(menu, action, type);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = this.slots.get(index);
        if (slot.m_6657_()) {
            ItemStack itemInSlot = slot.m_7993_();
            itemStack = itemInSlot.m_41777_();
            for (Rule rule : this.rules) {
                if (!rule.isValid() || !rule.filter().test(slot)) continue;
                if (this.action.moveItemStackTo(itemInSlot, rule.startIndex(), rule.endIndex(), rule.reverseDirection())) break;
                if (this.type != Type.STRICT) continue;
                return ItemStack.f_41583_;
            }
            if (itemInSlot.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemInSlot.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemInSlot);
        }
        return this.type == Type.RELAXED ? ItemStack.f_41583_ : itemStack;
    }

    public QuickMoveRuleSet addContainerSlotRule(int ... indices) {
        for (int index : indices) {
            this.addContainerSlotRule(index);
        }
        return this;
    }

    public QuickMoveRuleSet addContainerSlotRule(int index) {
        return this.addContainerSlotRule(index, (Predicate<Slot>)Predicates.alwaysTrue());
    }

    public QuickMoveRuleSet addContainerSlotRule(int index, Predicate<Slot> filter) {
        return this.addContainerSlotRule(index, false, filter);
    }

    public QuickMoveRuleSet addContainerSlotRule(int index, boolean reverseDirection, Predicate<Slot> filter) {
        return this.addRule(new Rule(Rule.Type.CONTAINER_SLOT, index, index + 1, reverseDirection, slot -> IS_INVENTORY.test((Slot)slot) && this.slots.get(index).m_5857_(slot.m_7993_()) && filter.test((Slot)slot)));
    }

    public QuickMoveRuleSet addContainerRule(Container container) {
        return this.addContainerRule(this.getInclusiveStartIndex(slot -> slot.f_40218_ == container), this.getExclusiveEndIndex(slot -> slot.f_40218_ == container));
    }

    public QuickMoveRuleSet addContainerRule(int startIndex, int endIndex) {
        return this.addRule(new Rule(Rule.Type.CONTAINER, startIndex, endIndex, false, slot -> slot.f_40219_ >= this.getInclusiveStartIndex(IS_INVENTORY_ITEMS) && slot.f_40219_ < this.getExclusiveEndIndex(IS_INVENTORY_ITEMS)));
    }

    public QuickMoveRuleSet addInventoryRules() {
        return this.addInventoryRules(true);
    }

    public QuickMoveRuleSet addInventoryRules(boolean reverseDirection) {
        this.addInventoryRule(Rule.Type.INVENTORY_ARMOR, reverseDirection, IS_INVENTORY_ARMOR);
        return this.addInventoryRule(Rule.Type.INVENTORY_ITEMS, reverseDirection, IS_INVENTORY_ITEMS);
    }

    private QuickMoveRuleSet addInventoryRule(Rule.Type type, boolean reverseDirection, Predicate<Slot> filter) {
        return this.addRule(new Rule(type, this.getInclusiveStartIndex(filter), this.getExclusiveEndIndex(filter), reverseDirection, IS_INVENTORY.negate()));
    }

    public QuickMoveRuleSet addInventoryCompartmentRules() {
        this.addInventoryCompartmentRule(Rule.Type.TO_ARMOR, Rule.Type.FROM_ARMOR, IS_INVENTORY_ARMOR, IS_INVENTORY_ITEMS);
        return this.addInventoryCompartmentRule(Rule.Type.TO_HOTBAR, Rule.Type.FROM_HOTBAR, IS_HOTBAR, IS_NOT_HOTBAR);
    }

    private QuickMoveRuleSet addInventoryCompartmentRule(Rule.Type to, Rule.Type from, Predicate<Slot> toFilter, Predicate<Slot> fromFilter) {
        this.addRule(new Rule(to, this.getInclusiveStartIndex(toFilter), this.getExclusiveEndIndex(toFilter), false, slot -> slot.f_40219_ >= this.getInclusiveStartIndex(fromFilter) && slot.f_40219_ < this.getExclusiveEndIndex(fromFilter)));
        return this.addRule(new Rule(from, this.getInclusiveStartIndex(fromFilter), this.getExclusiveEndIndex(fromFilter), false, slot -> slot.f_40219_ >= this.getInclusiveStartIndex(toFilter) && slot.f_40219_ < this.getExclusiveEndIndex(toFilter)));
    }

    private QuickMoveRuleSet addRule(Rule rule) {
        this.rules.add(rule);
        return this;
    }

    private int getInclusiveStartIndex(Predicate<Slot> predicate) {
        for (int i = 0; i < this.slots.size(); ++i) {
            if (!predicate.test(this.slots.get(i))) continue;
            return i;
        }
        return -1;
    }

    private int getExclusiveEndIndex(Predicate<Slot> predicate) {
        for (int i = this.slots.size() - 1; i >= 0; --i) {
            if (!predicate.test(this.slots.get(i))) continue;
            return i + 1;
        }
        return -1;
    }

    @FunctionalInterface
    public static interface Action {
        public boolean moveItemStackTo(ItemStack var1, int var2, int var3, boolean var4);
    }

    public static enum Type {
        STRICT,
        RELAXED,
        LENIENT;

    }

    private record Rule(Type type, int startIndex, int endIndex, boolean reverseDirection, Predicate<Slot> filter) {
        public boolean isValid() {
            return this.startIndex != -1 && this.endIndex != -1;
        }

        static enum Type {
            CONTAINER_SLOT,
            CONTAINER,
            INVENTORY_ITEMS,
            INVENTORY_ARMOR,
            TO_HOTBAR,
            FROM_HOTBAR,
            TO_ARMOR,
            FROM_ARMOR;

        }
    }
}

