/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.satin.impl;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import ladysnake.satin.Satin;
import ladysnake.satin.api.managed.ManagedCoreShader;
import ladysnake.satin.api.managed.uniform.SamplerUniform;
import ladysnake.satin.impl.ManagedSamplerUniformV1;
import ladysnake.satin.impl.ManagedUniformBase;
import ladysnake.satin.impl.RenderLayerSupplier;
import ladysnake.satin.impl.ResettableManagedShaderBase;
import net.fabricmc.fabric.impl.client.rendering.FabricShaderProgram;
import net.minecraft.class_1921;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5912;
import net.minecraft.class_5944;

public final class ResettableManagedCoreShader
extends ResettableManagedShaderBase<class_5944>
implements ManagedCoreShader {
    private final Consumer<ManagedCoreShader> initCallback;
    private final RenderLayerSupplier renderLayerSupplier;
    private final class_293 vertexFormat;
    private final Map<String, ManagedSamplerUniformV1> managedSamplers = new HashMap<String, ManagedSamplerUniformV1>();

    public ResettableManagedCoreShader(class_2960 location, class_293 vertexFormat, Consumer<ManagedCoreShader> initCallback) {
        super(location);
        this.vertexFormat = vertexFormat;
        this.initCallback = initCallback;
        this.renderLayerSupplier = RenderLayerSupplier.shader(String.format("%s_%d", location, System.identityHashCode(this)), vertexFormat, this::getProgram);
    }

    @Override
    protected class_5944 parseShader(class_5912 resourceManager, class_310 mc, class_2960 location) throws IOException {
        return new FabricShaderProgram(resourceManager, this.getLocation(), this.vertexFormat);
    }

    @Override
    public void setup(int newWidth, int newHeight) {
        Preconditions.checkNotNull((Object)((class_5944)this.shader));
        for (ManagedUniformBase uniform : this.getManagedUniforms()) {
            this.setupUniform(uniform, (class_5944)this.shader);
        }
        this.initCallback.accept(this);
    }

    @Override
    public class_5944 getProgram() {
        return (class_5944)this.shader;
    }

    @Override
    public class_1921 getRenderLayer(class_1921 baseLayer) {
        return this.renderLayerSupplier.getRenderLayer(baseLayer);
    }

    @Override
    protected boolean setupUniform(ManagedUniformBase uniform, class_5944 shader) {
        return uniform.findUniformTarget(shader);
    }

    @Override
    public SamplerUniform findSampler(String samplerName) {
        return this.manageUniform(this.managedSamplers, ManagedSamplerUniformV1::new, samplerName, "sampler");
    }

    @Override
    protected void logInitError(IOException e) {
        Satin.LOGGER.error("Could not create shader program {}", (Object)this.getLocation(), (Object)e);
    }
}

