/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.facet;

import guideme.internal.shaded.lucene.facet.DrillSidewaysScorer;
import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.search.BulkScorer;
import guideme.internal.shaded.lucene.search.Collector;
import guideme.internal.shaded.lucene.search.CollectorManager;
import guideme.internal.shaded.lucene.search.ConstantScoreScorer;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.Explanation;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.Scorer;
import guideme.internal.shaded.lucene.search.ScorerSupplier;
import guideme.internal.shaded.lucene.search.Weight;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

class DrillSidewaysQuery<K extends Collector, R>
extends Query {
    final Query baseQuery;
    final List<? extends CollectorManager<K, R>> drillSidewaysCollectorManagers;
    final List<List<K>> managedDrillSidewaysCollectors;
    final Query[] drillDownQueries;
    final boolean scoreSubDocsAtOnce;

    DrillSidewaysQuery(Query baseQuery, List<? extends CollectorManager<K, R>> drillSidewaysCollectorManagers, Query[] drillDownQueries, boolean scoreSubDocsAtOnce) {
        this(baseQuery, drillSidewaysCollectorManagers, Collections.synchronizedList(new ArrayList()), drillDownQueries, scoreSubDocsAtOnce);
    }

    private DrillSidewaysQuery(Query baseQuery, List<? extends CollectorManager<K, R>> drillSidewaysCollectorManagers, List<List<K>> managedDrillSidewaysCollectors, Query[] drillDownQueries, boolean scoreSubDocsAtOnce) {
        this.baseQuery = Objects.requireNonNull(baseQuery);
        this.drillSidewaysCollectorManagers = drillSidewaysCollectorManagers;
        this.drillDownQueries = drillDownQueries;
        this.scoreSubDocsAtOnce = scoreSubDocsAtOnce;
        this.managedDrillSidewaysCollectors = managedDrillSidewaysCollectors;
    }

    @Override
    public String toString(String field) {
        return "DrillSidewaysQuery";
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query rewrittenQuery;
        Query newQuery = this.baseQuery;
        while ((rewrittenQuery = newQuery.rewrite(indexSearcher)) != newQuery) {
            newQuery = rewrittenQuery;
        }
        if (newQuery == this.baseQuery) {
            return super.rewrite(indexSearcher);
        }
        return new DrillSidewaysQuery<K, R>(newQuery, this.drillSidewaysCollectorManagers, this.managedDrillSidewaysCollectors, this.drillDownQueries, this.scoreSubDocsAtOnce);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf(this);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        final Weight baseWeight = this.baseQuery.createWeight(searcher, scoreMode, boost);
        final Weight[] drillDowns = new Weight[this.drillDownQueries.length];
        for (int dim = 0; dim < this.drillDownQueries.length; ++dim) {
            drillDowns[dim] = searcher.createWeight(searcher.rewrite(this.drillDownQueries[dim]), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        }
        return new Weight(this){

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                return baseWeight.explain(context, doc);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }

            @Override
            public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                ScorerSupplier baseScorerSupplier = baseWeight.scorerSupplier(context);
                int drillDownCount = drillDowns.length;
                ArrayList sidewaysCollectors = new ArrayList(drillDownCount);
                DrillSidewaysQuery.this.managedDrillSidewaysCollectors.add(sidewaysCollectors);
                DrillSidewaysScorer.DocsAndCost[] dims = new DrillSidewaysScorer.DocsAndCost[drillDownCount];
                int nullCount = 0;
                for (int dim = 0; dim < dims.length; ++dim) {
                    Scorer scorer = drillDowns[dim].scorer(context);
                    if (scorer == null) {
                        ++nullCount;
                        scorer = new ConstantScoreScorer(drillDowns[dim], 0.0f, scoreMode, DocIdSetIterator.empty());
                    }
                    Object sidewaysCollector = DrillSidewaysQuery.this.drillSidewaysCollectorManagers.get(dim).newCollector();
                    sidewaysCollectors.add(dim, sidewaysCollector);
                    dims[dim] = new DrillSidewaysScorer.DocsAndCost(scorer, sidewaysCollector.getLeafCollector(context));
                }
                if (baseScorerSupplier == null || nullCount > 1) {
                    for (DrillSidewaysScorer.DocsAndCost dim : dims) {
                        dim.sidewaysLeafCollector.finish();
                    }
                    return null;
                }
                Arrays.sort(dims, Comparator.comparingLong(o -> o.approximation.cost()));
                return new DrillSidewaysScorer(context, baseScorerSupplier.get(Long.MAX_VALUE), dims, DrillSidewaysQuery.this.scoreSubDocsAtOnce);
            }
        };
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + Objects.hashCode(this.baseQuery);
        result = 31 * result + Arrays.hashCode(this.drillDownQueries);
        result = 31 * result + Objects.hashCode(this.drillSidewaysCollectorManagers);
        return result;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((DrillSidewaysQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(DrillSidewaysQuery<?, ?> other) {
        return Objects.equals(this.baseQuery, other.baseQuery) && Arrays.equals(this.drillDownQueries, other.drillDownQueries) && Objects.equals(this.drillSidewaysCollectorManagers, other.drillSidewaysCollectorManagers);
    }
}

