/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.facet.taxonomy.directory;

import guideme.internal.shaded.lucene.facet.taxonomy.ParallelTaxonomyArrays;
import guideme.internal.shaded.lucene.facet.taxonomy.directory.Consts;
import guideme.internal.shaded.lucene.index.CorruptIndexException;
import guideme.internal.shaded.lucene.index.IndexReader;
import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.MultiTerms;
import guideme.internal.shaded.lucene.index.NumericDocValues;
import guideme.internal.shaded.lucene.index.PostingsEnum;
import guideme.internal.shaded.lucene.internal.hppc.IntHashSet;
import guideme.internal.shaded.lucene.util.Accountable;
import guideme.internal.shaded.lucene.util.Accountables;
import guideme.internal.shaded.lucene.util.ArrayUtil;
import guideme.internal.shaded.lucene.util.RamUsageEstimator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

class TaxonomyIndexArrays
extends ParallelTaxonomyArrays
implements Accountable {
    private static final int CHUNK_SIZE_BITS = 13;
    static final int CHUNK_SIZE = 8192;
    private static final int CHUNK_MASK = 8191;
    private final ChunkedIntArray parents;
    private volatile boolean initializedChildren = false;
    private ChunkedIntArray children;
    private ChunkedIntArray siblings;

    TaxonomyIndexArrays(int[][] parents) {
        this.parents = new ChunkedIntArray(parents);
    }

    public TaxonomyIndexArrays(IndexReader reader) throws IOException {
        int[][] parentArray = TaxonomyIndexArrays.allocateChunkedArray(reader.maxDoc(), 0);
        assert (parentArray.length > 0);
        if (parentArray[0].length > 0) {
            this.initParents(parentArray, reader, 0);
            parentArray[0][0] = -1;
        }
        this.parents = new ChunkedIntArray(parentArray);
    }

    public TaxonomyIndexArrays(IndexReader reader, TaxonomyIndexArrays copyFrom) throws IOException {
        assert (copyFrom != null);
        int[][] parentArray = TaxonomyIndexArrays.allocateChunkedArray(reader.maxDoc(), copyFrom.parents.values.length - 1);
        assert (parentArray.length > 0);
        TaxonomyIndexArrays.copyChunkedArray(copyFrom.parents.values, parentArray);
        this.initParents(parentArray, reader, copyFrom.parents.length());
        this.parents = new ChunkedIntArray(parentArray);
        if (copyFrom.initializedChildren) {
            this.initChildrenSiblings(copyFrom);
        }
    }

    private static int[][] allocateChunkedArray(int size, int startFrom) {
        int chunkCount = (size >> 13) + 1;
        int[][] array = new int[chunkCount][];
        for (int i = startFrom; i < chunkCount - 1; ++i) {
            array[i] = new int[8192];
        }
        array[chunkCount - 1] = new int[size & 0x1FFF];
        return array;
    }

    private static void copyChunkedArray(int[][] oldArray, int[][] newArray) {
        if (oldArray.length > 1) {
            System.arraycopy(oldArray, 0, newArray, 0, oldArray.length - 1);
        }
        int[] lastCopyChunk = oldArray[oldArray.length - 1];
        System.arraycopy(lastCopyChunk, 0, newArray[oldArray.length - 1], 0, lastCopyChunk.length);
    }

    private synchronized void initChildrenSiblings(TaxonomyIndexArrays copyFrom) {
        if (!this.initializedChildren) {
            int startFrom = copyFrom == null ? 0 : copyFrom.parents.values.length - 1;
            int[][] childrenArray = TaxonomyIndexArrays.allocateChunkedArray(this.parents.length(), startFrom);
            int[][] siblingsArray = TaxonomyIndexArrays.allocateChunkedArray(this.parents.length(), startFrom);
            this.children = new ChunkedIntArray(childrenArray);
            this.siblings = new ChunkedIntArray(siblingsArray);
            if (copyFrom != null) {
                TaxonomyIndexArrays.copyChunkedArray(copyFrom.children.values, childrenArray);
                TaxonomyIndexArrays.copyChunkedArray(copyFrom.siblings.values, siblingsArray);
                this.computeChildrenSiblings(copyFrom.parents.length());
            } else {
                this.computeChildrenSiblings(0);
            }
            this.initializedChildren = true;
        }
    }

    private void computeChildrenSiblings(int first) {
        int length = this.parents.length();
        for (int i = first; i < length; ++i) {
            this.children.set(i, -1);
        }
        if (first == 0) {
            first = 1;
            this.siblings.set(0, -1);
        }
        int firstChunkStart = first - (first & 0x1FFF);
        IntHashSet reallocatedChildChunks = new IntHashSet();
        for (int i = first; i < length; ++i) {
            int chunkIdx;
            int parent = this.parents.get(i);
            this.siblings.set(i, this.children.get(parent));
            if (parent < firstChunkStart && !reallocatedChildChunks.contains(chunkIdx = parent >> 13)) {
                reallocatedChildChunks.add(chunkIdx);
                int[] oldChildren = this.children.values[chunkIdx];
                this.children.values[chunkIdx] = new int[8192];
                System.arraycopy(oldChildren, 0, this.children.values[chunkIdx], 0, oldChildren.length);
            }
            this.children.set(parent, i);
        }
    }

    private void initParents(int[][] parentsArray, IndexReader reader, int first) throws IOException {
        if (reader.maxDoc() == first) {
            return;
        }
        if (TaxonomyIndexArrays.getMajorVersion(reader) <= 8) {
            this.loadParentUsingTermPosition(parentsArray, reader, first);
            return;
        }
        for (LeafReaderContext leafContext : reader.leaves()) {
            int leafDocNum = leafContext.reader().maxDoc();
            if (leafContext.docBase + leafDocNum <= first) continue;
            NumericDocValues parentValues = leafContext.reader().getNumericDocValues("$parent_ndv$");
            if (parentValues == null) {
                throw new CorruptIndexException("Parent data field $parent_ndv$ does not exist", leafContext.reader().toString());
            }
            for (int doc = Math.max(first - leafContext.docBase, 0); doc < leafDocNum; ++doc) {
                if (!parentValues.advanceExact(doc)) {
                    throw new CorruptIndexException("Missing parent data for category " + (doc + leafContext.docBase), reader.toString());
                }
                int pos = doc + leafContext.docBase;
                parentsArray[pos >> 13][pos & 0x1FFF] = Math.toIntExact(parentValues.longValue());
            }
        }
    }

    private static int getMajorVersion(IndexReader reader) {
        assert (reader.leaves().size() > 0);
        return reader.leaves().get(0).reader().getMetaData().getCreatedVersionMajor();
    }

    private void loadParentUsingTermPosition(int[][] parentsArray, IndexReader reader, int first) throws IOException {
        PostingsEnum positions = MultiTerms.getTermPostingsEnum(reader, "$payloads$", Consts.PAYLOAD_PARENT_BYTES_REF, 88);
        if (positions == null || positions.advance(first) == Integer.MAX_VALUE) {
            throw new CorruptIndexException("[Lucene 8] Missing parent data for category " + first, reader.toString());
        }
        int num = reader.maxDoc();
        for (int i = first; i < num; ++i) {
            if (positions.docID() == i) {
                if (positions.freq() == 0) {
                    throw new CorruptIndexException("[Lucene 8] Missing parent data for category " + i, reader.toString());
                }
                parentsArray[i >> 13][i & 0x1FFF] = positions.nextPosition();
                if (positions.nextDoc() != Integer.MAX_VALUE) continue;
                if (i + 1 >= num) break;
                throw new CorruptIndexException("[Lucene 8] Missing parent data for category " + (i + 1), reader.toString());
            }
            throw new CorruptIndexException("[Lucene 8] Missing parent data for category " + i, reader.toString());
        }
    }

    TaxonomyIndexArrays add(int ordinal, int parentOrdinal) {
        if (ordinal >= this.parents.length()) {
            int[][] newParents = TaxonomyIndexArrays.allocateChunkedArray(ArrayUtil.oversize(ordinal + 1, 4), this.parents.values.length - 1);
            TaxonomyIndexArrays.copyChunkedArray(this.parents.values, newParents);
            newParents[ordinal >> 13][ordinal & 0x1FFF] = parentOrdinal;
            return new TaxonomyIndexArrays(newParents);
        }
        this.parents.set(ordinal, parentOrdinal);
        return this;
    }

    @Override
    public ChunkedIntArray parents() {
        return this.parents;
    }

    @Override
    public ChunkedIntArray children() {
        if (!this.initializedChildren) {
            this.initChildrenSiblings(null);
        }
        return this.children;
    }

    @Override
    public ChunkedIntArray siblings() {
        if (!this.initializedChildren) {
            this.initChildrenSiblings(null);
        }
        return this.siblings;
    }

    @Override
    public synchronized long ramBytesUsed() {
        long ramBytesUsed = (long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 3L * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + 1L;
        ramBytesUsed += RamUsageEstimator.shallowSizeOf(this.parents);
        if (this.children != null) {
            ramBytesUsed += RamUsageEstimator.shallowSizeOf(this.children);
        }
        if (this.siblings != null) {
            ramBytesUsed += RamUsageEstimator.shallowSizeOf(this.siblings);
        }
        return ramBytesUsed;
    }

    @Override
    public synchronized Collection<Accountable> getChildResources() {
        ArrayList<Accountable> resources = new ArrayList<Accountable>();
        resources.add(Accountables.namedAccountable("parents", RamUsageEstimator.shallowSizeOf(this.parents)));
        if (this.children != null) {
            resources.add(Accountables.namedAccountable("children", RamUsageEstimator.shallowSizeOf(this.children)));
        }
        if (this.siblings != null) {
            resources.add(Accountables.namedAccountable("siblings", RamUsageEstimator.shallowSizeOf(this.siblings)));
        }
        return Collections.unmodifiableList(resources);
    }

    static class ChunkedIntArray
    extends ParallelTaxonomyArrays.IntArray {
        final int[][] values;

        private ChunkedIntArray(int[][] values) {
            this.values = values;
        }

        @Override
        public int get(int i) {
            return this.values[i >> 13][i & 0x1FFF];
        }

        public void set(int i, int val) {
            this.values[i >> 13][i & 0x1FFF] = val;
        }

        @Override
        public int length() {
            return (this.values.length - 1 << 13) + this.values[this.values.length - 1].length;
        }
    }
}

