/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.FloatVectorValues;
import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.search.AbstractVectorSimilarityQuery;
import guideme.internal.shaded.lucene.search.KnnCollector;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.TopDocs;
import guideme.internal.shaded.lucene.search.VectorScorer;
import guideme.internal.shaded.lucene.search.VectorSimilarityCollector;
import guideme.internal.shaded.lucene.util.Bits;
import guideme.internal.shaded.lucene.util.VectorUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;

public class FloatVectorSimilarityQuery
extends AbstractVectorSimilarityQuery {
    private final float[] target;

    public FloatVectorSimilarityQuery(String field, float[] target, float traversalSimilarity, float resultSimilarity, Query filter) {
        super(field, traversalSimilarity, resultSimilarity, filter);
        this.target = VectorUtil.checkFinite(Objects.requireNonNull(target, "target"));
    }

    public FloatVectorSimilarityQuery(String field, float[] target, float traversalSimilarity, float resultSimilarity) {
        this(field, target, traversalSimilarity, resultSimilarity, null);
    }

    public FloatVectorSimilarityQuery(String field, float[] target, float resultSimilarity, Query filter) {
        this(field, target, resultSimilarity, resultSimilarity, filter);
    }

    public FloatVectorSimilarityQuery(String field, float[] target, float resultSimilarity) {
        this(field, target, resultSimilarity, resultSimilarity, null);
    }

    @Override
    VectorScorer createVectorScorer(LeafReaderContext context) throws IOException {
        FloatVectorValues vectorValues = context.reader().getFloatVectorValues(this.field);
        if (vectorValues == null) {
            return null;
        }
        return vectorValues.scorer(this.target);
    }

    @Override
    protected TopDocs approximateSearch(LeafReaderContext context, Bits acceptDocs, int visitLimit) throws IOException {
        VectorSimilarityCollector collector = new VectorSimilarityCollector(this.traversalSimilarity, this.resultSimilarity, visitLimit);
        context.reader().searchNearestVectors(this.field, this.target, (KnnCollector)collector, acceptDocs);
        return collector.topDocs();
    }

    @Override
    public String toString(String field) {
        return String.format(Locale.ROOT, "%s[field=%s target=[%f...] traversalSimilarity=%f resultSimilarity=%f filter=%s]", this.getClass().getSimpleName(), field, Float.valueOf(this.target[0]), Float.valueOf(this.traversalSimilarity), Float.valueOf(this.resultSimilarity), this.filter);
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && super.equals(o) && Arrays.equals(this.target, ((FloatVectorSimilarityQuery)o).target);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.target);
        return result;
    }
}

