/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.search.BooleanClause;
import guideme.internal.shaded.lucene.search.BooleanQuery;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.Weight;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public abstract class IndriQuery
extends Query
implements Iterable<BooleanClause> {
    private List<BooleanClause> clauses;

    public IndriQuery(List<BooleanClause> clauses) {
        this.clauses = clauses;
    }

    @Override
    public abstract Weight createWeight(IndexSearcher var1, ScoreMode var2, float var3) throws IOException;

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        for (BooleanClause c : this) {
            buffer.append(c.getOccur().toString());
            Query subQuery = c.getQuery();
            if (subQuery instanceof BooleanQuery) {
                buffer.append("(");
                buffer.append(subQuery.toString(field));
                buffer.append(")");
            } else {
                buffer.append(subQuery.toString(field));
            }
            if (i != this.clauses.size() - 1) {
                buffer.append(" ");
            }
            ++i;
        }
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo((IndriQuery)this.getClass().cast(o));
    }

    @Override
    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf(this);
    }

    private boolean equalsTo(IndriQuery other) {
        return this.clauses.equals(other.clauses);
    }

    @Override
    public int hashCode() {
        int hashCode = Objects.hash(this.clauses);
        if (hashCode == 0) {
            hashCode = 1;
        }
        return hashCode;
    }

    @Override
    public Iterator<BooleanClause> iterator() {
        return this.clauses.iterator();
    }

    public List<BooleanClause> getClauses() {
        return this.clauses;
    }
}

