/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search.matchhighlight;

import guideme.internal.shaded.lucene.search.MatchesIterator;
import guideme.internal.shaded.lucene.search.matchhighlight.MatchRegionRetriever;
import guideme.internal.shaded.lucene.search.matchhighlight.OffsetRange;
import guideme.internal.shaded.lucene.search.matchhighlight.OffsetsFromPositions;
import guideme.internal.shaded.lucene.search.matchhighlight.OffsetsRetrievalStrategy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class OffsetsFromMatchIterator
implements OffsetsRetrievalStrategy {
    private final String field;
    private final OffsetsFromPositions noOffsetsFallback;

    public OffsetsFromMatchIterator(String field, OffsetsFromPositions noOffsetsFallback) {
        this.field = field;
        this.noOffsetsFallback = Objects.requireNonNull(noOffsetsFallback);
    }

    @Override
    public List<OffsetRange> get(MatchesIterator matchesIterator, MatchRegionRetriever.FieldValueProvider doc) throws IOException {
        ArrayList<OffsetRange> positionRanges = new ArrayList<OffsetRange>();
        ArrayList<OffsetRange> offsetRanges = new ArrayList<OffsetRange>();
        while (matchesIterator.next()) {
            int fromPosition = matchesIterator.startPosition();
            int toPosition = matchesIterator.endPosition();
            if (fromPosition < 0 || toPosition < 0) {
                throw new IOException("Matches API returned negative positions for field: " + this.field);
            }
            positionRanges.add(new OffsetRange(fromPosition, toPosition));
            if (offsetRanges == null) continue;
            int from = matchesIterator.startOffset();
            int to = matchesIterator.endOffset();
            if (from < 0 || to < 0) {
                offsetRanges = null;
                continue;
            }
            offsetRanges.add(new OffsetRange(from, to));
        }
        if (offsetRanges == null) {
            return this.noOffsetsFallback.convertPositionsToOffsets(positionRanges, doc.getValues(this.field));
        }
        return offsetRanges;
    }
}

