/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.gen;

import mcjty.lostcities.worldgen.ChunkDriver;
import mcjty.lostcities.worldgen.LostCityTerrainFeature;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.cityassets.CompiledPalette;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;

public class Corridors {
    public static void generateCorridors(LostCityTerrainFeature feature, BuildingInfo info, boolean xRail, boolean zRail) {
        BlockState air = Blocks.f_50016_.m_49966_();
        BlockState base = info.profile.getBaseBlock();
        BlockState railx = (BlockState)Blocks.f_50156_.m_49966_().m_61124_((Property)RailBlock.f_55392_, (Comparable)RailShape.EAST_WEST);
        BlockState railz = Blocks.f_50156_.m_49966_();
        ChunkDriver driver = feature.driver;
        Character corridorRoofBlock = info.getCityStyle().getCorridorRoofBlock();
        Character corridorGlassBlock = info.getCityStyle().getCorridorGlassBlock();
        CompiledPalette palette = info.getCompiledPalette();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (xRail && z >= 7 && z <= 10 || zRail && x >= 7 && x <= 10) {
                    int height = info.groundLevel - 6;
                    BlockState b = xRail && z == 10 ? railx : (zRail && x == 10 ? railz : air);
                    driver.current(x, height, z).add(palette.get(corridorRoofBlock.charValue())).add(b).add(air).add(air);
                    if (xRail && x == 7 && (z == 8 || z == 9) || zRail && z == 7 && (x == 8 || x == 9)) {
                        driver.add(palette.get(corridorGlassBlock.charValue()));
                        BlockPos pos = driver.getCurrentCopy();
                        Character glowstoneChar = info.getCityStyle().getGlowstoneBlock();
                        BlockState glowstone = glowstoneChar == null ? Blocks.f_50141_.m_49966_() : palette.get(glowstoneChar.charValue());
                        driver.add(glowstone);
                        LostCityTerrainFeature.updateNeeded(info, pos, 2);
                        continue;
                    }
                    BlockState roof = palette.get(corridorRoofBlock.charValue());
                    driver.add(roof).add(roof);
                    continue;
                }
                driver.setBlockRange(x, info.groundLevel - 5, z, info.getCityGroundLevel(), base);
            }
        }
    }

    public static void generateCorridorConnections(ChunkDriver driver, BuildingInfo info) {
        int x;
        int z;
        int z2;
        int x2;
        if (info.getXmin().hasXCorridor()) {
            x2 = 0;
            for (z2 = 7; z2 <= 10; ++z2) {
                driver.setBlockRangeToAir(x2, info.groundLevel - 5, z2, info.groundLevel - 2);
            }
        }
        if (info.getXmax().hasXCorridor()) {
            x2 = 15;
            for (z2 = 7; z2 <= 10; ++z2) {
                driver.setBlockRangeToAir(x2, info.groundLevel - 5, z2, info.groundLevel - 2);
            }
        }
        if (info.getZmin().hasZCorridor()) {
            z = 0;
            for (x = 7; x <= 10; ++x) {
                driver.setBlockRangeToAir(x, info.groundLevel - 5, z, info.groundLevel - 2);
            }
        }
        if (info.getZmax().hasZCorridor()) {
            z = 15;
            for (x = 7; x <= 10; ++x) {
                driver.setBlockRangeToAir(x, info.groundLevel - 5, z, info.groundLevel - 2);
            }
        }
    }
}

