/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.regassets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import mcjty.lostcities.worldgen.lost.regassets.IAsset;
import mcjty.lostcities.worldgen.lost.regassets.data.CityBiomeMultiplier;
import mcjty.lostcities.worldgen.lost.regassets.data.CitySphereSettings;
import mcjty.lostcities.worldgen.lost.regassets.data.CityStyleSelector;
import mcjty.lostcities.worldgen.lost.regassets.data.MultiSettings;
import mcjty.lostcities.worldgen.lost.regassets.data.PartSelector;
import mcjty.lostcities.worldgen.lost.regassets.data.ScatteredSettings;
import mcjty.lostcities.worldgen.lost.regassets.data.WorldSettings;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class WorldStyleRE
implements IAsset<WorldStyleRE> {
    public static final Codec<WorldStyleRE> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("outsidestyle").forGetter(l -> l.outsideStyle), (App)MultiSettings.CODEC.optionalFieldOf("multisettings").forGetter(l -> l.multiSettings.get()), (App)WorldSettings.CODEC.optionalFieldOf("settings").forGetter(l -> l.worldSettings.get()), (App)CitySphereSettings.CODEC.optionalFieldOf("cityspheres").forGetter(l -> Optional.ofNullable(l.citysphereSettings)), (App)ScatteredSettings.CODEC.optionalFieldOf("scattered").forGetter(l -> Optional.ofNullable(l.scatteredSettings)), (App)PartSelector.CODEC.optionalFieldOf("parts").forGetter(l -> l.partSelector.get()), (App)Codec.list(CityStyleSelector.CODEC).fieldOf("citystyles").forGetter(l -> l.cityStyleSelectors), (App)Codec.list(CityBiomeMultiplier.CODEC).optionalFieldOf("citybiomemultipliers").forGetter(l -> Optional.ofNullable(l.cityBiomeMultipliers))).apply((Applicative)instance, WorldStyleRE::new));
    private ResourceLocation name;
    private final String outsideStyle;
    private final MultiSettings multiSettings;
    private final WorldSettings worldSettings;
    private final ScatteredSettings scatteredSettings;
    private final CitySphereSettings citysphereSettings;
    @Nonnull
    private final PartSelector partSelector;
    private final List<CityStyleSelector> cityStyleSelectors;
    private final List<CityBiomeMultiplier> cityBiomeMultipliers;

    public WorldStyleRE(String outsideStyle, Optional<MultiSettings> multiSettings, Optional<WorldSettings> worldSettings, Optional<CitySphereSettings> citysphereSettings, Optional<ScatteredSettings> scatteredSettings, Optional<PartSelector> partSelector, List<CityStyleSelector> cityStyleSelector, Optional<List<CityBiomeMultiplier>> cityBiomeMultipliers) {
        this.outsideStyle = outsideStyle;
        this.multiSettings = multiSettings.orElse(MultiSettings.DEFAULT);
        this.worldSettings = worldSettings.orElse(WorldSettings.DEFAULT);
        this.citysphereSettings = citysphereSettings.orElse(null);
        this.scatteredSettings = scatteredSettings.orElse(null);
        this.partSelector = partSelector.orElse(PartSelector.DEFAULT);
        this.cityStyleSelectors = cityStyleSelector;
        this.cityBiomeMultipliers = cityBiomeMultipliers.orElse(null);
    }

    public String getOutsideStyle() {
        return this.outsideStyle;
    }

    @Nonnull
    public PartSelector getPartSelector() {
        return this.partSelector;
    }

    public CitySphereSettings getCitysphereSettings() {
        return this.citysphereSettings;
    }

    @Nullable
    public ScatteredSettings getScatteredSettings() {
        return this.scatteredSettings;
    }

    public List<CityStyleSelector> getCityStyleSelectors() {
        return this.cityStyleSelectors;
    }

    public List<CityBiomeMultiplier> getCityBiomeMultipliers() {
        return this.cityBiomeMultipliers;
    }

    @Nonnull
    public MultiSettings getMultiSettings() {
        return this.multiSettings;
    }

    @Nonnull
    public WorldSettings getWorldSettings() {
        return this.worldSettings;
    }

    @Override
    public WorldStyleRE setRegistryName(ResourceLocation name) {
        this.name = name;
        return this;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.name;
    }
}

