/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.regassets.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;

public class BiomeMatcher
implements Predicate<Holder<Biome>> {
    private final Optional<List<HolderSet<Biome>>> ifAll;
    private final Optional<List<HolderSet<Biome>>> ifAny;
    private final Optional<List<HolderSet<Biome>>> excluding;
    public static final Codec<BiomeMatcher> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Biome.f_47432_.listOf().optionalFieldOf("if_all").forGetter(BiomeMatcher::getIfAll), (App)Biome.f_47432_.listOf().optionalFieldOf("if_any").forGetter(BiomeMatcher::getIfAny), (App)Biome.f_47432_.listOf().optionalFieldOf("excluding").forGetter(BiomeMatcher::getExcluding)).apply((Applicative)codec, BiomeMatcher::new));
    public static final BiomeMatcher ANY = new BiomeMatcher(Optional.empty(), Optional.empty(), Optional.empty()){

        @Override
        public boolean test(Holder<Biome> biome) {
            return true;
        }
    };

    public BiomeMatcher(Optional<List<HolderSet<Biome>>> ifAll, Optional<List<HolderSet<Biome>>> ifAny, Optional<List<HolderSet<Biome>>> excluding) {
        this.ifAll = ifAll;
        this.ifAny = ifAny;
        this.excluding = excluding;
    }

    private Optional<List<HolderSet<Biome>>> getIfAll() {
        return this.ifAll;
    }

    private Optional<List<HolderSet<Biome>>> getIfAny() {
        return this.ifAny;
    }

    private Optional<List<HolderSet<Biome>>> getExcluding() {
        return this.excluding;
    }

    @Override
    public boolean test(Holder<Biome> biome) {
        if (this.ifAll.isPresent() && !this.ifAll.get().stream().allMatch(set -> set.m_203333_(biome))) {
            return false;
        }
        if (this.ifAny.isPresent() && this.ifAny.get().stream().noneMatch(set -> set.m_203333_(biome))) {
            return false;
        }
        return this.excluding.isEmpty() || this.excluding.get().stream().noneMatch(set -> set.m_203333_(biome));
    }
}

