/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.regassets.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import mcjty.lostcities.worldgen.lost.regassets.data.ScatteredReference;

public class ScatteredSettings {
    public static final Codec<ScatteredSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("areasize").forGetter(l -> l.areasize), (App)Codec.FLOAT.fieldOf("chance").forGetter(l -> Float.valueOf(l.chance)), (App)Codec.INT.fieldOf("weightnone").forGetter(l -> l.weightnone), (App)Codec.list(ScatteredReference.CODEC).fieldOf("list").forGetter(l -> l.list)).apply((Applicative)instance, ScatteredSettings::new));
    private final int areasize;
    private final float chance;
    private final int weightnone;
    private final List<ScatteredReference> list;
    private int totalweight;

    public ScatteredSettings(int areasize, float chance, int weightnone, List<ScatteredReference> list) {
        this.areasize = areasize;
        this.chance = chance;
        this.weightnone = weightnone;
        this.list = list;
        this.totalweight = 0;
        for (ScatteredReference reference : list) {
            this.totalweight += reference.getWeight();
        }
    }

    public int getAreasize() {
        return this.areasize;
    }

    public int getWeightnone() {
        return this.weightnone;
    }

    public float getChance() {
        return this.chance;
    }

    public int getTotalweight() {
        return this.totalweight;
    }

    public List<ScatteredReference> getList() {
        return this.list;
    }
}

