/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.ae2;

import appeng.api.behaviors.ContainerItemStrategy;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import me.ramidzkh.mekae2.MekCapabilities;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.SlurryStack;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class ChemicalContainerItemStrategy
implements ContainerItemStrategy<MekanismKey, ItemStack> {
    @Nullable
    public GenericStack getContainedStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        for (Capability<ISlurryHandler> capability : List.of(MekCapabilities.GAS_HANDLER_CAPABILITY, MekCapabilities.INFUSION_HANDLER_CAPABILITY, MekCapabilities.PIGMENT_HANDLER_CAPABILITY, MekCapabilities.SLURRY_HANDLER_CAPABILITY)) {
            ChemicalStack chemical;
            MekanismKey key;
            Optional contained = stack.getCapability(capability).map(handler -> handler.extractChemical(Long.MAX_VALUE, Action.SIMULATE));
            if (!contained.isPresent() || (key = MekanismKey.of(chemical = (ChemicalStack)contained.get())) == null) continue;
            return new GenericStack((AEKey)key, chemical.getAmount());
        }
        return null;
    }

    @Nullable
    public ItemStack findCarriedContext(Player player, AbstractContainerMenu menu) {
        ItemStack carried = menu.m_142621_();
        if (Stream.of(MekCapabilities.GAS_HANDLER_CAPABILITY, MekCapabilities.INFUSION_HANDLER_CAPABILITY, MekCapabilities.PIGMENT_HANDLER_CAPABILITY, MekCapabilities.SLURRY_HANDLER_CAPABILITY).anyMatch(capability -> carried.getCapability(capability).isPresent())) {
            return carried;
        }
        return null;
    }

    @Nullable
    public ItemStack findPlayerSlotContext(Player player, int slot) {
        ItemStack carried = player.m_150109_().m_8020_(slot);
        if (Stream.of(MekCapabilities.GAS_HANDLER_CAPABILITY, MekCapabilities.INFUSION_HANDLER_CAPABILITY, MekCapabilities.PIGMENT_HANDLER_CAPABILITY, MekCapabilities.SLURRY_HANDLER_CAPABILITY).anyMatch(capability -> carried.getCapability(capability).isPresent())) {
            return carried;
        }
        return null;
    }

    public long extract(ItemStack context, MekanismKey what, long amount, Actionable mode) {
        ChemicalStack<?> stack = what.withAmount(amount);
        Action action = Action.fromFluidAction((IFluidHandler.FluidAction)mode.getFluidAction());
        if (stack instanceof GasStack) {
            GasStack gas = (GasStack)stack;
            return context.getCapability(MekCapabilities.GAS_HANDLER_CAPABILITY).map(handler -> ((GasStack)handler.extractChemical((ChemicalStack)gas, action)).getAmount()).orElse(0L);
        }
        if (stack instanceof InfusionStack) {
            InfusionStack infusion = (InfusionStack)stack;
            return context.getCapability(MekCapabilities.INFUSION_HANDLER_CAPABILITY).map(handler -> ((InfusionStack)handler.extractChemical((ChemicalStack)infusion, action)).getAmount()).orElse(0L);
        }
        if (stack instanceof PigmentStack) {
            PigmentStack pigment = (PigmentStack)stack;
            return context.getCapability(MekCapabilities.PIGMENT_HANDLER_CAPABILITY).map(handler -> ((PigmentStack)handler.extractChemical((ChemicalStack)pigment, action)).getAmount()).orElse(0L);
        }
        if (stack instanceof SlurryStack) {
            SlurryStack slurry = (SlurryStack)stack;
            return context.getCapability(MekCapabilities.SLURRY_HANDLER_CAPABILITY).map(handler -> ((SlurryStack)handler.extractChemical((ChemicalStack)slurry, action)).getAmount()).orElse(0L);
        }
        throw new UnsupportedOperationException();
    }

    public long insert(ItemStack context, MekanismKey what, long amount, Actionable mode) {
        ChemicalStack<?> stack = what.withAmount(amount);
        Action action = Action.fromFluidAction((IFluidHandler.FluidAction)mode.getFluidAction());
        if (stack instanceof GasStack) {
            GasStack gas = (GasStack)stack;
            return context.getCapability(MekCapabilities.GAS_HANDLER_CAPABILITY).map(handler -> amount - ((GasStack)handler.insertChemical((ChemicalStack)gas, action)).getAmount()).orElse(0L);
        }
        if (stack instanceof InfusionStack) {
            InfusionStack infusion = (InfusionStack)stack;
            return context.getCapability(MekCapabilities.INFUSION_HANDLER_CAPABILITY).map(handler -> amount - ((InfusionStack)handler.insertChemical((ChemicalStack)infusion, action)).getAmount()).orElse(0L);
        }
        if (stack instanceof PigmentStack) {
            PigmentStack pigment = (PigmentStack)stack;
            return context.getCapability(MekCapabilities.PIGMENT_HANDLER_CAPABILITY).map(handler -> amount - ((PigmentStack)handler.insertChemical((ChemicalStack)pigment, action)).getAmount()).orElse(0L);
        }
        if (stack instanceof SlurryStack) {
            SlurryStack slurry = (SlurryStack)stack;
            return context.getCapability(MekCapabilities.SLURRY_HANDLER_CAPABILITY).map(handler -> amount - ((SlurryStack)handler.insertChemical((ChemicalStack)slurry, action)).getAmount()).orElse(0L);
        }
        throw new UnsupportedOperationException();
    }

    public void playFillSound(Player player, MekanismKey what) {
        player.m_6330_(SoundEvents.f_11781_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public void playEmptySound(Player player, MekanismKey what) {
        player.m_6330_(SoundEvents.f_11778_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Nullable
    public GenericStack getExtractableContent(ItemStack context) {
        return this.getContainedStack(context);
    }
}

