/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.blockentities;

import com.direwolf20.buildinggadgets2.client.particles.fluidparticle.FluidFlowParticleData;
import com.direwolf20.buildinggadgets2.client.particles.itemparticle.ItemFlowParticleData;
import com.direwolf20.buildinggadgets2.setup.Registration;
import com.direwolf20.buildinggadgets2.util.GadgetUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;

public class RenderBlockBE
extends BlockEntity {
    public byte drawSize;
    public BlockState renderBlock;
    public BlockState sourceBlock;
    public BlockState targetBlock;
    public CompoundTag blockEntityData;
    public boolean shrinking;
    public boolean exchanging;
    public byte renderType;

    public RenderBlockBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.RenderBlock_BE.get(), pos, state);
    }

    public void tickClient() {
        this.increaseDrawSize();
        if (this.renderType == 5) {
            this.drawParticles();
        }
    }

    public void drawParticles() {
        if (this.renderBlock == null) {
            return;
        }
        Random random = new Random();
        float nowScale = (float)this.drawSize / (float)this.getMaxSize();
        if (this.renderBlock.m_60819_().m_76178_()) {
            if (this.shrinking) {
                if (nowScale != 0.0f && nowScale < 0.5f) {
                    return;
                }
                ItemStack itemStack = GadgetUtils.getSimpleItemForBlock(this.renderBlock);
                BlockPos startPos = this.m_58899_();
                if (nowScale != 0.0f) {
                    float yscale = Mth.m_14179_((float)nowScale, (float)0.75f, (float)1.0f);
                    ItemFlowParticleData data = new ItemFlowParticleData(itemStack, false, this.shrinking);
                    for (int i = 0; i < 2; ++i) {
                        double randomX = random.nextFloat();
                        double randomZ = random.nextFloat();
                        this.f_58857_.m_7106_((ParticleOptions)data, (double)startPos.m_123341_() + randomX, (double)((float)startPos.m_123342_() + yscale), (double)startPos.m_123343_() + randomZ, 0.0, 0.0, 0.0);
                    }
                } else {
                    ItemFlowParticleData data = new ItemFlowParticleData(itemStack, true, this.shrinking);
                    for (int i = 0; i < 100; ++i) {
                        double randomX = random.nextFloat();
                        double randomY = random.nextFloat();
                        double randomZ = random.nextFloat();
                        this.f_58857_.m_7106_((ParticleOptions)data, (double)startPos.m_123341_() + randomX, (double)startPos.m_123342_() + randomY, (double)startPos.m_123343_() + randomZ, 0.0, 0.0, 0.0);
                    }
                }
            } else {
                int i;
                ItemFlowParticleData data;
                ItemStack itemStack = GadgetUtils.getSimpleItemForBlock(this.renderBlock);
                BlockPos startPos = this.m_58899_();
                if ((double)nowScale < 0.05) {
                    data = new ItemFlowParticleData(itemStack, true, !this.shrinking);
                    for (i = 0; i < 100; ++i) {
                        double randomX = random.nextFloat();
                        double randomY = random.nextFloat();
                        double randomZ = random.nextFloat();
                        this.f_58857_.m_7106_((ParticleOptions)data, (double)startPos.m_123341_() + randomX, (double)startPos.m_123342_() + randomY, (double)startPos.m_123343_() + randomZ, 0.0, 0.0, 0.0);
                    }
                }
                if (nowScale > 0.5f) {
                    return;
                }
                data = new ItemFlowParticleData(itemStack, false, this.shrinking);
                for (i = 0; i < 2; ++i) {
                    this.f_58857_.m_7106_((ParticleOptions)data, (double)((float)startPos.m_123341_() + 0.5f), (double)((float)startPos.m_123342_() + 0.5f), (double)((float)startPos.m_123343_() + 0.5f), 0.0, 0.0, 0.0);
                }
            }
        } else if (this.shrinking) {
            if (nowScale != 0.0f && nowScale < 0.5f) {
                return;
            }
            BlockPos startPos = this.m_58899_();
            if (nowScale != 0.0f) {
                float yscale = Mth.m_14179_((float)nowScale, (float)0.75f, (float)1.0f);
                FluidFlowParticleData data = new FluidFlowParticleData(new FluidStack(this.renderBlock.m_60819_().m_76152_(), 1000), false, this.shrinking);
                for (int i = 0; i < 2; ++i) {
                    double randomX = random.nextFloat();
                    double randomZ = random.nextFloat();
                    this.f_58857_.m_7106_((ParticleOptions)data, (double)startPos.m_123341_() + randomX, (double)((float)startPos.m_123342_() + yscale), (double)startPos.m_123343_() + randomZ, 0.0, 0.0, 0.0);
                }
            } else {
                FluidFlowParticleData data = new FluidFlowParticleData(new FluidStack(this.renderBlock.m_60819_().m_76152_(), 1000), true, this.shrinking);
                for (int i = 0; i < 100; ++i) {
                    double randomX = random.nextFloat();
                    double randomY = random.nextFloat();
                    double randomZ = random.nextFloat();
                    this.f_58857_.m_7106_((ParticleOptions)data, (double)startPos.m_123341_() + randomX, (double)startPos.m_123342_() + randomY, (double)startPos.m_123343_() + randomZ, 0.0, 0.0, 0.0);
                }
            }
        } else {
            int i;
            FluidFlowParticleData data;
            BlockPos startPos = this.m_58899_();
            if ((double)nowScale < 0.05) {
                data = new FluidFlowParticleData(new FluidStack(this.renderBlock.m_60819_().m_76152_(), 1000), true, !this.shrinking);
                for (i = 0; i < 100; ++i) {
                    double randomX = random.nextFloat();
                    double randomY = random.nextFloat();
                    double randomZ = random.nextFloat();
                    this.f_58857_.m_7106_((ParticleOptions)data, (double)startPos.m_123341_() + randomX, (double)startPos.m_123342_() + randomY, (double)startPos.m_123343_() + randomZ, 0.0, 0.0, 0.0);
                }
            }
            if (nowScale > 0.5f) {
                return;
            }
            data = new FluidFlowParticleData(new FluidStack(this.renderBlock.m_60819_().m_76152_(), 1000), false, this.shrinking);
            for (i = 0; i < 2; ++i) {
                this.f_58857_.m_7106_((ParticleOptions)data, (double)((float)startPos.m_123341_() + 0.5f), (double)((float)startPos.m_123342_() + 0.5f), (double)((float)startPos.m_123343_() + 0.5f), 0.0, 0.0, 0.0);
            }
        }
    }

    public void tickServer() {
        this.increaseDrawSize();
        if (this.shrinking && this.drawSize <= 0) {
            if (this.exchanging) {
                this.shrinking = false;
                this.renderBlock = this.targetBlock;
                this.markDirtyClient();
            } else {
                this.setRealBlock(Blocks.f_50016_.m_49966_());
            }
        } else if (this.drawSize >= this.getMaxSize()) {
            this.setRealBlock(this.targetBlock);
        }
    }

    public byte getMaxSize() {
        if (this.renderType == 5) {
            return 40;
        }
        return 20;
    }

    public void setRealBlock(BlockState realBlock) {
        List<ItemStack> drops;
        Iterator<ItemStack> iterator;
        if (realBlock == null) {
            this.f_58857_.m_46597_(this.m_58899_(), Blocks.f_50016_.m_49966_());
            return;
        }
        if (!realBlock.m_60710_((LevelReader)this.f_58857_, this.m_58899_()) && (iterator = (drops = GadgetUtils.getDropsForBlockState((ServerLevel)this.f_58857_, this.m_58899_(), realBlock, null)).iterator()).hasNext()) {
            ItemStack returnedItem = iterator.next();
            ItemEntity itementity = new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), returnedItem);
            itementity.m_32010_(40);
            this.f_58857_.m_7967_((Entity)itementity);
            this.f_58857_.m_46597_(this.m_58899_(), Blocks.f_50016_.m_49966_());
            return;
        }
        BlockState adjustedState = Block.m_49931_((BlockState)realBlock, (LevelAccessor)this.f_58857_, (BlockPos)this.m_58899_());
        this.f_58857_.m_46597_(this.m_58899_(), adjustedState);
        if (this.blockEntityData != null) {
            BlockEntity newBE = this.f_58857_.m_7702_(this.m_58899_());
            try {
                newBE.m_142466_(this.blockEntityData);
            }
            catch (Exception e) {
                System.out.println("Failed to restore tile data for block at: " + this.m_58899_() + " with NBT: " + this.blockEntityData + ". Consider adding it to the blacklist");
            }
        }
    }

    public void increaseDrawSize() {
        if (this.shrinking) {
            this.drawSize = (byte)(this.drawSize - 1);
            if (this.drawSize <= 0) {
                this.drawSize = 0;
            }
        } else {
            this.drawSize = (byte)(this.drawSize + 1);
            if (this.drawSize >= this.getMaxSize()) {
                this.drawSize = this.getMaxSize();
            }
        }
    }

    public byte nextDrawSize() {
        if (this.shrinking) {
            return (byte)(this.drawSize - 1);
        }
        return (byte)(this.drawSize + 1);
    }

    public void setRenderData(BlockState sourceBlock, BlockState targetBlock, byte renderType) {
        this.sourceBlock = sourceBlock;
        this.targetBlock = targetBlock;
        this.renderType = renderType;
        if (sourceBlock.equals(Blocks.f_50016_.m_49966_())) {
            this.exchanging = false;
            this.shrinking = false;
            this.renderBlock = targetBlock;
            this.drawSize = 0;
        } else if (targetBlock.equals(Blocks.f_50016_.m_49966_())) {
            this.exchanging = false;
            this.shrinking = true;
            this.renderBlock = sourceBlock;
            this.drawSize = this.getMaxSize();
        } else {
            this.exchanging = true;
            this.shrinking = true;
            this.renderBlock = sourceBlock;
            this.drawSize = this.getMaxSize();
        }
        this.markDirtyClient();
    }

    public void setBlockEntityData(CompoundTag tag) {
        this.blockEntityData = tag;
        this.markDirtyClient();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.renderBlock = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)tag.m_128469_("renderBlock"));
        this.sourceBlock = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)tag.m_128469_("sourceBlock"));
        this.targetBlock = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)tag.m_128469_("targetBlock"));
        this.shrinking = tag.m_128471_("shrinking");
        this.exchanging = tag.m_128471_("exchanging");
        this.drawSize = tag.m_128445_("drawSize");
        this.renderType = tag.m_128445_("renderType");
        if (tag.m_128441_("blockEntityData")) {
            this.blockEntityData = tag.m_128469_("blockEntityData");
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.renderBlock != null) {
            tag.m_128365_("renderBlock", (Tag)NbtUtils.m_129202_((BlockState)this.renderBlock));
        }
        if (this.sourceBlock != null) {
            tag.m_128365_("sourceBlock", (Tag)NbtUtils.m_129202_((BlockState)this.sourceBlock));
        }
        if (this.targetBlock != null) {
            tag.m_128365_("targetBlock", (Tag)NbtUtils.m_129202_((BlockState)this.targetBlock));
        }
        tag.m_128379_("shrinking", this.shrinking);
        tag.m_128379_("exchanging", this.exchanging);
        tag.m_128344_("drawSize", this.drawSize);
        tag.m_128344_("renderType", this.renderType);
        if (this.blockEntityData != null) {
            tag.m_128365_("blockEntityData", (Tag)this.blockEntityData);
        }
    }

    @Nonnull
    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_().m_6630_(10).m_122013_(10).m_122030_(10), this.m_58899_().m_6625_(10).m_122020_(10).m_122025_(10));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() == null) {
            return;
        }
        this.m_142466_(pkt.m_131708_());
    }

    public void markDirtyClient() {
        this.m_6596_();
        if (this.m_58904_() != null) {
            BlockState state = this.m_58904_().m_8055_(this.m_58899_());
            this.m_58904_().m_7260_(this.m_58899_(), state, state, 3);
        }
    }

    public void m_7651_() {
        super.m_7651_();
    }

    public void m_6339_() {
        super.m_6339_();
    }
}

