/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.util;

import com.direwolf20.buildinggadgets2.api.gadgets.GadgetModes;
import com.direwolf20.buildinggadgets2.api.gadgets.GadgetTarget;
import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.common.items.GadgetBuilding;
import com.direwolf20.buildinggadgets2.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets2.common.items.GadgetCutPaste;
import com.direwolf20.buildinggadgets2.common.items.GadgetExchanger;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import com.direwolf20.buildinggadgets2.util.DimBlockPos;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class GadgetNBT {
    public static final BlockPos nullPos = new BlockPos(-999, -999, -999);
    static final int undoListSize = 10;

    public static DimBlockPos setBoundPos(ItemStack gadget, DimBlockPos dimBlockPos) {
        CompoundTag tag = gadget.m_41784_();
        tag.m_128365_("bound", (Tag)dimBlockPos.toNBT());
        return dimBlockPos;
    }

    public static DimBlockPos getBoundPos(ItemStack gadget) {
        CompoundTag tag = gadget.m_41783_();
        if (tag == null || !tag.m_128441_("bound")) {
            return null;
        }
        return new DimBlockPos(tag.m_128469_("bound"));
    }

    public static void clearBoundPos(ItemStack gadget) {
        CompoundTag tag = gadget.m_41783_();
        if (tag == null || !tag.m_128441_("bound")) {
            return;
        }
        tag.m_128473_("bound");
    }

    public static BlockPos setAnchorPos(ItemStack gadget, BlockPos blockPos) {
        CompoundTag tag = gadget.m_41784_();
        tag.m_128365_("anchor", (Tag)NbtUtils.m_129224_((BlockPos)blockPos));
        return blockPos;
    }

    public static byte setRenderType(ItemStack gadget, byte renderType) {
        CompoundTag tag = gadget.m_41784_();
        tag.m_128344_("rendertype", renderType);
        return renderType;
    }

    public static byte getRenderTypeByte(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound == null || !tagCompound.m_128441_("rendertype")) {
            return 0;
        }
        return tagCompound.m_128445_("rendertype");
    }

    public static RenderTypes getRenderType(ItemStack stack) {
        return RenderTypes.getByOrdinal(GadgetNBT.getRenderTypeByte(stack));
    }

    public static BlockPos getAnchorPos(ItemStack gadget) {
        CompoundTag tag = gadget.m_41783_();
        if (tag == null || !tag.m_128441_("anchor")) {
            return nullPos;
        }
        return NbtUtils.m_129239_((CompoundTag)tag.m_128469_("anchor"));
    }

    public static void clearAnchorPos(ItemStack gadget) {
        CompoundTag tag = gadget.m_41783_();
        if (tag == null || !tag.m_128441_("anchor")) {
            return;
        }
        tag.m_128473_("anchor");
        tag.m_128473_("anchorList");
        tag.m_128473_("anchorside");
    }

    public static ArrayList<BlockPos> getAnchorList(ItemStack gadget) {
        ArrayList<BlockPos> anchorList = new ArrayList<BlockPos>();
        CompoundTag tag = gadget.m_41783_();
        if (tag == null || !tag.m_128441_("anchorList")) {
            return anchorList;
        }
        ListTag coordList = tag.m_128437_("anchorList", 10);
        if (coordList.size() == 0) {
            return anchorList;
        }
        for (int i = 0; i < coordList.size(); ++i) {
            anchorList.add(NbtUtils.m_129239_((CompoundTag)coordList.m_128728_(i)));
        }
        return anchorList;
    }

    public static void setAnchorList(ItemStack gadget, ArrayList<BlockPos> anchorList) {
        CompoundTag tagCompound = gadget.m_41784_();
        tagCompound.m_128365_("anchorList", (Tag)anchorList.stream().map(NbtUtils::m_129224_).collect(Collectors.toCollection(ListTag::new)));
    }

    public static void setAnchorSide(ItemStack stack, Direction side) {
        CompoundTag tag = stack.m_41784_();
        if (side == null) {
            tag.m_128473_("anchorside");
        } else {
            tag.m_128405_("anchorside", side.ordinal());
        }
    }

    public static Direction getAnchorSide(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("anchorside")) {
            return null;
        }
        int side = tag.m_128451_("anchorside");
        return Direction.values()[side];
    }

    public static BlockPos setCopyStartPos(ItemStack gadget, BlockPos blockPos) {
        CompoundTag tag = gadget.m_41784_();
        tag.m_128365_("copystart", (Tag)NbtUtils.m_129224_((BlockPos)blockPos));
        return blockPos;
    }

    public static BlockPos getCopyStartPos(ItemStack gadget) {
        CompoundTag tag = gadget.m_41783_();
        if (tag == null || !tag.m_128441_("copystart")) {
            return nullPos;
        }
        return NbtUtils.m_129239_((CompoundTag)tag.m_128469_("copystart"));
    }

    public static BlockPos setRelativePaste(ItemStack gadget, BlockPos blockPos) {
        CompoundTag tag = gadget.m_41784_();
        tag.m_128365_("relativepaste", (Tag)NbtUtils.m_129224_((BlockPos)blockPos));
        return blockPos;
    }

    public static BlockPos getRelativePaste(ItemStack gadget) {
        CompoundTag tag = gadget.m_41783_();
        if (tag == null || !tag.m_128441_("relativepaste")) {
            return BlockPos.f_121853_;
        }
        return NbtUtils.m_129239_((CompoundTag)tag.m_128469_("relativepaste"));
    }

    public static BlockPos setCopyEndPos(ItemStack gadget, BlockPos blockPos) {
        CompoundTag tag = gadget.m_41784_();
        tag.m_128365_("copyend", (Tag)NbtUtils.m_129224_((BlockPos)blockPos));
        return blockPos;
    }

    public static BlockPos getCopyEndPos(ItemStack gadget) {
        CompoundTag tag = gadget.m_41783_();
        if (tag == null || !tag.m_128441_("copyend")) {
            return nullPos;
        }
        return NbtUtils.m_129239_((CompoundTag)tag.m_128469_("copyend"));
    }

    public static UUID setUUID(ItemStack gadget) {
        CompoundTag tag = gadget.m_41784_();
        UUID uuid = UUID.randomUUID();
        tag.m_128362_("uuid", uuid);
        return uuid;
    }

    public static UUID getUUID(ItemStack gadget) {
        CompoundTag tag = gadget.m_41783_();
        if (tag == null || !tag.m_128441_("uuid")) {
            return GadgetNBT.setUUID(gadget);
        }
        return tag.m_128342_("uuid");
    }

    public static UUID setCopyUUID(ItemStack gadget) {
        CompoundTag tag = gadget.m_41784_();
        UUID uuid = UUID.randomUUID();
        tag.m_128362_("copyuuid", uuid);
        return uuid;
    }

    public static UUID setCopyUUID(ItemStack gadget, UUID uuid) {
        CompoundTag tag = gadget.m_41784_();
        tag.m_128362_("copyuuid", uuid);
        return uuid;
    }

    public static UUID getCopyUUID(ItemStack gadget) {
        CompoundTag tag = gadget.m_41783_();
        if (tag == null || !tag.m_128441_("copyuuid")) {
            return GadgetNBT.setCopyUUID(gadget);
        }
        return tag.m_128342_("copyuuid");
    }

    public static boolean hasCopyUUID(ItemStack gadget) {
        CompoundTag tag = gadget.m_41783_();
        return tag != null && tag.m_128441_("copyuuid");
    }

    public static void clearCopyUUID(ItemStack gadget) {
        CompoundTag tag = gadget.m_41783_();
        if (tag == null || !tag.m_128441_("copyuuid")) {
            return;
        }
        tag.m_128473_("copyuuid");
    }

    public static BlockState setGadgetBlockState(ItemStack gadget, BlockState blockState) {
        CompoundTag tag = gadget.m_41784_();
        tag.m_128365_("blockstate", (Tag)NbtUtils.m_129202_((BlockState)blockState));
        return blockState;
    }

    public static BlockState getGadgetBlockState(ItemStack gadget) {
        CompoundTag tag = gadget.m_41783_();
        if (tag == null || !tag.m_128441_("blockstate")) {
            return Blocks.f_50016_.m_49966_();
        }
        return NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)tag.m_128469_("blockstate"));
    }

    public static boolean shouldRayTraceFluid(ItemStack stack) {
        return GadgetNBT.getSetting(stack, "raytracefluid");
    }

    public static LinkedList<UUID> getUndoList(ItemStack gadget) {
        LinkedList<UUID> undoList = new LinkedList<UUID>();
        CompoundTag tag = gadget.m_41784_();
        if (!tag.m_128441_("undolist")) {
            return undoList;
        }
        ListTag undoListTag = tag.m_128437_("undolist", 10);
        for (int i = 0; i < undoListTag.size(); ++i) {
            UUID uuid = undoListTag.m_128728_(i).m_128342_("uuid");
            undoList.offer(uuid);
        }
        return undoList;
    }

    public static void setUndoList(ItemStack gadget, LinkedList<UUID> undoList) {
        CompoundTag tag = gadget.m_41784_();
        ListTag undoListTag = new ListTag();
        for (UUID id : undoList) {
            CompoundTag temptag = new CompoundTag();
            temptag.m_128362_("uuid", id);
            undoListTag.add((Object)temptag);
        }
        tag.m_128365_("undolist", (Tag)undoListTag);
    }

    public static void addToUndoList(ItemStack gadget, UUID uuid, BG2Data bg2Data) {
        LinkedList<UUID> undoList = GadgetNBT.getUndoList(gadget);
        if (undoList.size() >= 10) {
            UUID removal = undoList.removeFirst();
            bg2Data.removeFromUndoList(removal);
        }
        undoList.add(uuid);
        GadgetNBT.setUndoList(gadget, undoList);
    }

    public static UUID peekUndoList(ItemStack gadget) {
        LinkedList<UUID> undoList = GadgetNBT.getUndoList(gadget);
        if (undoList.isEmpty()) {
            return null;
        }
        return undoList.getLast();
    }

    public static UUID popUndoList(ItemStack gadget) {
        LinkedList<UUID> undoList = GadgetNBT.getUndoList(gadget);
        if (undoList.isEmpty()) {
            return null;
        }
        UUID uuid = undoList.removeLast();
        GadgetNBT.setUndoList(gadget, undoList);
        return uuid;
    }

    public static boolean toggleSetting(ItemStack stack, String setting) {
        CompoundTag tagCompound;
        tagCompound.m_128379_(setting, !(tagCompound = stack.m_41784_()).m_128471_(setting));
        return tagCompound.m_128471_(setting);
    }

    public static boolean getSetting(ItemStack stack, String setting) {
        CompoundTag tagCompound = stack.m_41784_();
        return tagCompound.m_128471_(setting);
    }

    public static boolean getPasteReplace(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("pastereplace")) {
            if (stack.m_41720_() instanceof GadgetCutPaste) {
                return GadgetNBT.toggleSetting(stack, "pastereplace");
            }
            return false;
        }
        return tag.m_128471_("pastereplace");
    }

    public static void setToolRange(ItemStack stack, int range) {
        CompoundTag tagCompound = stack.m_41784_();
        tagCompound.m_128405_("range", range);
    }

    public static int getToolRange(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41784_();
        return Mth.m_14045_((int)tagCompound.m_128451_("range"), (int)1, (int)15);
    }

    public static void setToolValue(ItemStack stack, int value, String valueName) {
        stack.m_41784_().m_128405_(valueName, value);
    }

    public static int getToolValue(ItemStack stack, String valueName) {
        return stack.m_41784_().m_128451_(valueName);
    }

    public static void setTemplateName(ItemStack stack, String name) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("templatename", name);
    }

    public static String getTemplateName(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128461_("templatename");
    }

    public static boolean getFuzzy(ItemStack stack) {
        return GadgetNBT.getSetting(stack, "fuzzy");
    }

    public static BaseMode getMode(ItemStack stack) {
        Preconditions.checkArgument((boolean)(stack.m_41720_() instanceof BaseGadget), (Object)"You can not get a mode of a non-gadget item");
        String mode = stack.m_41784_().m_128461_("mode");
        GadgetTarget gadgetTarget = ((BaseGadget)stack.m_41720_()).gadgetTarget();
        ImmutableSortedSet<BaseMode> modesForGadget = GadgetModes.INSTANCE.getModesForGadget(gadgetTarget);
        if (mode.isEmpty()) {
            if (stack.m_41720_() instanceof GadgetBuilding) {
                return modesForGadget.stream().filter(m -> m.getId().equals((Object)"build_to_me")).findFirst().orElse((BaseMode)modesForGadget.first());
            }
            if (stack.m_41720_() instanceof GadgetExchanger) {
                return modesForGadget.stream().filter(m -> m.getId().equals((Object)"surface")).findFirst().orElse((BaseMode)modesForGadget.first());
            }
            if (stack.m_41720_() instanceof GadgetCutPaste) {
                return modesForGadget.stream().filter(m -> m.getId().equals((Object)"cut")).findFirst().orElse((BaseMode)modesForGadget.first());
            }
            if (stack.m_41720_() instanceof GadgetCopyPaste) {
                return modesForGadget.stream().filter(m -> m.getId().equals((Object)"copy")).findFirst().orElse((BaseMode)modesForGadget.first());
            }
            return (BaseMode)modesForGadget.first();
        }
        ResourceLocation id = new ResourceLocation(mode);
        return modesForGadget.stream().filter(m -> m.getId().equals((Object)id)).findFirst().orElse((BaseMode)modesForGadget.first());
    }

    public static void setMode(ItemStack gadget, BaseMode mode) {
        gadget.m_41784_().m_128359_("mode", mode.getId().toString());
    }

    public static enum RenderTypes {
        GROW("buildinggadgets2.grow"),
        FADE("buildinggadgets2.fade"),
        SQUISH("buildinggadgets2.squish"),
        GROWUP("buildinggadgets2.growup"),
        RISEUP("buildinggadgets2.riseup"),
        SNAP("buildinggadgets2.snap");

        private final String lang;

        private RenderTypes(String lang) {
            this.lang = lang;
        }

        public RenderTypes next() {
            return RenderTypes.values()[(this.ordinal() + 1) % RenderTypes.values().length];
        }

        public byte getPosition() {
            return (byte)this.ordinal();
        }

        public String getLang() {
            return this.lang;
        }

        public static RenderTypes getByOrdinal(byte ordinal) {
            return RenderTypes.values()[ordinal];
        }
    }

    public static enum NBTValues {
        FUZZY("fuzzy"),
        CONNECTED_AREA("connected_area");

        public final String value;

        private NBTValues(String value) {
            this.value = value;
        }
    }
}

