/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.util.modes;

import com.direwolf20.buildinggadgets2.common.blocks.RenderBlock;
import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.GadgetUtils;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class Copy
extends BaseMode {
    public Copy() {
        super(false);
    }

    @Override
    public ResourceLocation getId() {
        return new ResourceLocation("buildinggadgets2", "copy");
    }

    @Override
    public ArrayList<StatePos> collectWorld(Direction hitSide, Player player, BlockPos start, BlockState state) {
        int maxSize;
        ArrayList<StatePos> coordinates = new ArrayList<StatePos>();
        ItemStack heldItem = BaseGadget.getGadget(player);
        if (!(heldItem.m_41720_() instanceof GadgetCopyPaste)) {
            return coordinates;
        }
        Level level = player.m_9236_();
        BlockPos copyStart = GadgetNBT.getCopyStartPos(heldItem);
        BlockPos copyEnd = GadgetNBT.getCopyEndPos(heldItem);
        if (copyStart.equals((Object)GadgetNBT.nullPos) || copyEnd.equals((Object)GadgetNBT.nullPos)) {
            return coordinates;
        }
        AABB area = new AABB(copyStart, copyEnd);
        Stream areaStream = BlockPos.m_121921_((AABB)area);
        long size = areaStream.count();
        if (size > (long)(maxSize = 100000)) {
            player.m_5661_((Component)Component.m_237110_((String)"buildinggadgets2.messages.areatoolarge", (Object[])new Object[]{maxSize, size}), false);
            return coordinates;
        }
        BlockPos.m_121921_((AABB)area).map(BlockPos::m_7949_).forEach(pos -> {
            if (GadgetUtils.isValidBlockState(level.m_8055_(pos), level, pos) && !(level.m_8055_(pos).m_60734_() instanceof RenderBlock)) {
                coordinates.add(new StatePos(GadgetUtils.cleanBlockState(level.m_8055_(pos)), pos.m_121996_((Vec3i)copyStart)));
            } else {
                coordinates.add(new StatePos(Blocks.f_50016_.m_49966_(), pos.m_121996_((Vec3i)copyStart)));
            }
        });
        return coordinates;
    }
}

