/*
 * Decompiled with CFR 0.152.
 */
package cofh.requack.net.okhttp;

import cofh.requack.annotation.Requires;
import cofh.requack.net.download.DownloadListener;
import cofh.requack.net.okhttp.ProgressForwardingSource;
import cofh.requack.net.okhttp.SniffingResponseBody;
import java.io.IOException;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okio.Source;

@Requires(value="com.squareup.okhttp3:okhttp")
public class ProgressInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        ProgressTag tag = (ProgressTag)request.tag(ProgressTag.class);
        if (tag == null) {
            return chain.proceed(request);
        }
        tag.listener.connecting();
        Response response = chain.proceed(request);
        return response.newBuilder().body(SniffingResponseBody.ofFunction(Objects.requireNonNull(response.body()), e -> new ProgressForwardingSource((Source)e, tag.listener, tag.existingLen))).build();
    }

    public static class ProgressTag {
        public final long existingLen;
        public final DownloadListener listener;

        public ProgressTag(DownloadListener listener) {
            this(0L, listener);
        }

        public ProgressTag(long existingLen, DownloadListener listener) {
            this.existingLen = existingLen;
            this.listener = listener;
        }
    }
}

