/*
 * Decompiled with CFR 0.152.
 */
package cofh.requack.net.okhttp;

import cofh.requack.annotation.Requires;
import cofh.requack.net.okhttp.SniffingResponseBody;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Throttler;
import org.jetbrains.annotations.NotNull;

@Requires(value="com.squareup.okhttp3:okhttp")
public class ThrottlerInterceptor
implements Interceptor {
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Throttler throttler = (Throttler)request.tag(Throttler.class);
        Response response = chain.proceed(request);
        if (throttler == null) {
            return response;
        }
        ResponseBody body = response.body();
        if (body == null) {
            return response;
        }
        return response.newBuilder().body(SniffingResponseBody.ofFunction(body, arg_0 -> ((Throttler)throttler).source(arg_0))).build();
    }
}

