/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.grid.energy;

import cofh.lib.common.energy.IRedstoneFluxStorage;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;

public final class GridEnergyStorage
implements IRedstoneFluxStorage,
INBTSerializable<CompoundTag> {
    private long baseCapacity;
    private long capacity;
    private long energy;
    private byte sampleTracker = 0;
    private final long[] samplesOut = new long[40];
    private long rollingOut = 0L;
    private long averageOut = 0L;

    public GridEnergyStorage(long baseCapacity) {
        this.baseCapacity = baseCapacity;
    }

    public GridEnergyStorage setBaseCapacity(long baseCapacity) {
        this.baseCapacity = Math.max(0L, baseCapacity);
        return this;
    }

    public GridEnergyStorage setCapacity(long capacity) {
        this.capacity = capacity;
        this.resetTrackers();
        return this;
    }

    public GridEnergyStorage setEnergy(long energy) {
        this.energy = Math.max(0L, energy);
        return this;
    }

    public void resetTrackers() {
        this.sampleTracker = 0;
        this.rollingOut = 0L;
        this.averageOut = 0L;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getEnergy() {
        return this.energy;
    }

    public void tick() {
        this.samplesOut[this.sampleTracker] = this.energy;
    }

    public void postTick() {
        byte by = this.sampleTracker;
        this.samplesOut[by] = this.samplesOut[by] - this.energy;
        this.rollingOut += this.samplesOut[this.sampleTracker];
        this.averageOut = this.rollingOut / (long)this.samplesOut.length;
        this.sampleTracker = (byte)(this.sampleTracker + 1);
        if (this.sampleTracker >= this.samplesOut.length) {
            this.sampleTracker = 0;
            this.updateCapacity();
        }
        this.rollingOut -= this.samplesOut[this.sampleTracker];
        this.samplesOut[this.sampleTracker] = 0L;
    }

    private void updateCapacity() {
        this.capacity = Math.max(this.baseCapacity, 4L * this.averageOut);
    }

    public GridEnergyStorage read(CompoundTag nbt) {
        this.energy = nbt.m_128454_("Energy");
        this.baseCapacity = nbt.m_128454_("EnergyMax");
        this.averageOut = nbt.m_128454_("TrackOut");
        this.updateCapacity();
        return this;
    }

    public CompoundTag write(CompoundTag nbt) {
        nbt.m_128356_("Energy", this.energy);
        nbt.m_128356_("EnergyMax", this.baseCapacity);
        nbt.m_128356_("TrackOut", this.averageOut);
        return nbt;
    }

    public CompoundTag serializeNBT() {
        return this.write(new CompoundTag());
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.read(nbt);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        long energyReceived = Math.max(0L, Math.min(this.capacity - this.energy, (long)maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        return (int)energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        long energyExtracted = Math.min(this.energy, (long)maxExtract);
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return (int)energyExtracted;
    }

    public int getEnergyStored() {
        return this.energy > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.energy;
    }

    public int getMaxEnergyStored() {
        return this.capacity > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.capacity;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }
}

