/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.handler;

import cofh.thermal.dynamics.api.grid.IGridContainer;
import cofh.thermal.dynamics.handler.GridContainer;
import cofh.thermal.dynamics.handler.GridContainerCapProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.ChunkEvent;

public class GridEvents {
    public static void register() {
        MinecraftForge.EVENT_BUS.addGenericListener(Level.class, GridEvents::attachCapabilities);
        MinecraftForge.EVENT_BUS.addListener(GridEvents::onWorldTick);
        MinecraftForge.EVENT_BUS.addListener(GridEvents::onChunkLoad);
        MinecraftForge.EVENT_BUS.addListener(GridEvents::onChunkUnload);
    }

    private static void attachCapabilities(AttachCapabilitiesEvent<Level> event) {
        event.addCapability(new ResourceLocation("thermal_dynamics", "grid_container"), (ICapabilityProvider)new GridContainerCapProvider(new GridContainer((Level)event.getObject())));
    }

    private static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.side.isClient()) {
            return;
        }
        IGridContainer gridContainer = IGridContainer.getCapability((LevelAccessor)event.level);
        if (gridContainer != null) {
            ((GridContainer)gridContainer).onWorldTick(event.phase);
        }
    }

    private static void onChunkLoad(ChunkEvent.Load event) {
        IGridContainer gridContainer = IGridContainer.getCapability(event.getLevel());
        if (gridContainer != null) {
            ((GridContainer)gridContainer).onChunkLoad(event.getChunk());
        }
    }

    private static void onChunkUnload(ChunkEvent.Unload event) {
        IGridContainer gridContainer = IGridContainer.getCapability(event.getLevel());
        if (gridContainer != null) {
            ((GridContainer)gridContainer).onChunkUnload(event.getChunk());
        }
    }
}

